/* linkaware.h
   This file released to the public domain by Ben Darnell.
   You may use this file however you wish to make
   LinkMaster-compatible applications.
*/
/* You may #define the following symbols to reduce the compiled size of
   linkaware.c:
   NO_LINKSIMPLE
   NO_LINKCONTAINER
   NO_LINKHISTORY
   NO_LINKGLOBALS - removes a static variable from linkaware.c
*/
#ifndef _linkaware_h
#define _linkaware_h

#ifdef __GNUC__
#define LINKSECT __attribute__ ((section("ui2sect")))
#else
#define LINKSECT
#endif

/* All link-aware applications should include a resource of type
   'Link', number 1, containing a character indicating what version
   of the LinkMaster protocol the application implements.  For this
   version, that character should be 'a'.

   If you are using the GNU tools, you can create this resource by
   executing "echo a > Link0001.bin" and including Link0001.bin
   in your build-prc command.
*/

typedef struct {
   UInt32 creator;
   Char data[60];
} LinkInfoType;
typedef LinkInfoType* LinkInfoPtr;


#define linkAppLaunchRequestLink 0x8901
/* Sending: An application should send this launch code to LinkMaster to
   request a link.  The parameter block consists of one LinkInfoType
   structure, which will be returned with the link.

   Recieving: LinkMaster will send this launch code to an application
   when the user selects the application via the "New Link" command.
   No parameters will be sent.  The application is not required to
   behave specially in response to this launch code, but may for instance
   open in an index mode instead of viewing the previously edited record.
*/

#define linkAppLaunchReturnLink 0x8902
/* Sending: An application should send this launch code to LinkMaster after
   the user has selected a record to link to.  This may be done at any time,
   not just after recieving a linkAppLaunchRequestLink.  If there are no
   pending link requests, the link will be added to a list within
   LinkMaster.  The parameter block consists of one LinkInfoType structure
   plus an optional null-terminated string, which may be used to identify
   the link.

   Recieving: LinkMaster will send this launch code to an application which
   has previously requested a link.  The parameter block consists of two
   LinkInfoType structures - the one initially passed with
   linkAppLaunchRequestLink, and the one selected by the user - and a null-
   terminated string which identifies the link..
*/

#define linkAppLaunchFollowLink 0x8903
/* NOTE: see linkAppLaunchFollowLinkSubCall below
  Recieving: This code is sent to applications when the user follows
  a link.  The parameter block consist of the LinkInfoType structure
  that defines the link.  The application should display the record
  indicated by the link.
*/

#define linkAppLaunchHistoryPush 0x8904
/* Sending: An app passes a LinkInfoType structure to LinkMaster with
   this launch code to have it put in the history list
*/

#define linkAppLaunchHistoryBack 0x8905
#define linkAppLaunchHistoryForward 0x8906
/* Sending: Send one of these to LinkMaster with no parameters to go to
   the next or previous item in the history list
*/

#define linkAppLaunchFollowLinkSubCall 0x8907
/* Recieving: An app recieves this launch code first  when the user follows
   a link.  You should check to see if your globals are available
   with sysAppLaunchFlagSubCall.  If they are (the flag is set), your app
   is currently running and you should handle it in a similar way to
   sysAppLaunchCmdGoTo (e.g. by posting a frmGotoEvent and exiting).
   If not, you should switch to your app with SysUIAppSwitch, passing
   linkAppLaunchFollowLink and cmdPBP.
   Or, if you don't want to do that, you can SysUIAppSwitch in any case,
   at the expense of some performance.
*/

Boolean LinkCheck(void) LINKSECT;/* returns true if LinkMaster is installed */
Boolean LinkPublish(LinkInfoPtr linkinfo) LINKSECT;

#ifndef NO_LINKSIMPLE
typedef struct {
   UInt32 creator;
   UInt32 record_id;
   Char db_name[32];
} LinkSimpleType;
typedef LinkSimpleType* LinkSimplePtr;

LinkSimplePtr LinkSimpleNew(DmOpenRef db, UInt16 record_index, Char * title)
     LINKSECT ;
GoToParamsPtr LinkSimpleToGoToParams(LinkSimplePtr linkinfo) LINKSECT;
#endif /* NO_LINKSIMPLE */

#ifndef NO_LINKCONTAINER
void LinkRequest(LinkInfoPtr linkinfo) LINKSECT;
void LinkFollow(LinkInfoPtr linkinfo) LINKSECT;
#endif /* NO_LINKCONTAINER */

#ifndef NO_LINKHISTORY
/* this is stored in preference Link0000,
   but it's not really for external use */
typedef struct {
   UInt16 current;
   UInt16 max;
} LinkHistoryPrefsType; 

void LinkHistoryPush(LinkInfoPtr linkinfo) LINKSECT;
Boolean LinkHistoryBack(void) LINKSECT; /* returns true on success */
Boolean LinkHistoryForward(void) LINKSECT;
Boolean LinkHistoryBackCheck(void)
     LINKSECT ; /* returns true if possible to go back */
Boolean LinkHistoryForwardCheck(void) LINKSECT;
#endif /* NO_LINKHISTORY */

#endif /* _linkaware_h */
