#!/bin/sh
#
# Automate the building of the zip distribution so that we don't have
# to do it manually each time.

if [ "x$1" = "x" ]; then
  echo usage: $0 VERSION
  exit 0
fi

# Form the filename that we will use.
ver=`echo $1 | sed -e 's/\./_/g'`
zipfile="../db_${ver}.zip"

# Do some initial cleanups.
make distclean
rm -f "$zipfile"

# Add in all normal source files.
zip -l -r "$zipfile" * -x '*.bmp'

# Add in the binary files.
zip "$zipfile" *.bmp

# Build a version of DB for each language.
for lang in en de pt it fr ; do
  # Build the binary prc file.
  make "db-${lang}.prc"

  # Add this prc file to the zip file.
  zip "$zipfile" "db-${lang}.prc"  

  # Cleanup from this stage.
  make distclean
done
