/* xmphil.cc Philatelie for Linux */

#include <Xm/MainW.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushBG.h>
#include <X11/Xmu/Editres.h>
#include <Xbae/Matrix.h>
#include "marken.h"
/* #include "icon.h" */

#define VERSION "0.9"
#define TITLE "XmPhil"
#define DISW 500           // display width
#define DISH 300           // display hight
#define EMPTY ""           // empty cell;

/* global variables          */
/* Structure for menu system */
typedef struct {
  Widget f_menu;
  Widget n_data;
  Widget l_data;
  Widget s_data;
  Widget p_data;
  Widget quit;
} f_menu;

typedef struct {
  Widget e_menu;
  Widget w_edit;
  Widget c_edit;
  Widget u_edit;
} e_menu;

typedef struct {
  f_menu file;
  e_menu edit;
} main_menu;

typedef struct {
  short what;
  int year;
} print_struct;

String colors[] = {"Black", "Blue", "Green", "Red", "Yellow", "Magenta", "Cyan", "White"};

XtAppContext  app;
Widget        message;
Widget        marken_w; // Xbae Widget fr Marken;
main_menu     mymenu;
MARKEN        m;        // Marken;
Widget        toplevel; // toplevel;
print_struct  print_s;  // print structure;
unsigned long nsel;    // number of selected stamps;

main(int argc, char *argv[])
{
  Pixmap    bitmap;
  Widget    main_w;
  Widget    menubar, PullDown;
  int       i, j;
  int       rows, columns;
  String    *rowArrays, **cells, *clabels, *rlabels;
  short     *colwidth;
  char      mystr[256];

  extern void f_cb(Widget widget, XtPointer client_data, XtPointer call_data);
  extern void e_cb(Widget widget, XtPointer client_data, XtPointer call_data);
  void m_dc_cb(Widget widget, XtPointer client_data, XtPointer call_data);
  void m_ec_cb(Widget widget, XtPointer client_data, XtPointer call_data);
  void m_lc_cb(Widget widget, XtPointer client_data, XtPointer call_data);
  void m_la_cb(Widget widget, XtPointer client_data, XtPointer call_data);
  void set_message(unsigned long, unsigned long);

  /* Initialization */
  print_s.what=3;
  nsel=0;

  toplevel=XtVaAppInitialize(&app, TITLE, NULL, 0,
			     &argc, argv, NULL, NULL);
  /*  bitmap=XCreatePixmapFromBitmapData(XtDisplay(toplevel),
			  RootWindowOfScreen(XtScreen(toplevel)),
			  xmana_icon_bits, xmana_icon_width, xmana_icon_height,
			  1,0,1);
  */
  XtVaSetValues(toplevel, 
		//		XmNiconPixmap, bitmap,
		XmNtitle, TITLE" v"VERSION,
		NULL);
  XtAddEventHandler(toplevel, (EventMask)0, True,
		    _XEditResCheckMessages, NULL);

  /*   m a i n w i n d o w    */
  main_w=XtVaCreateManagedWidget("main_w", xmMainWindowWidgetClass, toplevel,
				 //XmNwidth, DISW,
				 //XmNheight, DISH,
			         NULL);

  /*   M e n u s y s t e m   */
  menubar = XmCreateMenuBar(main_w, "menubar",NULL,0);
  /*   F i l e m e n u   */;
  PullDown=XmCreatePulldownMenu(menubar, "FilePullDown", NULL,0);
  mymenu.file.f_menu=XtVaCreateManagedWidget("File",
			  xmCascadeButtonWidgetClass, menubar,
			  XmNlabelString, XmStringCreateLocalized("File"),
			  XmNmnemonic, 'F',
			  XmNsubMenuId, PullDown,
			  NULL);
  mymenu.file.n_data=XtVaCreateManagedWidget("New",
					  xmPushButtonGadgetClass, PullDown,
					  XmNmnemonic, 'N',
					  NULL);
  XtAddCallback(mymenu.file.n_data, XmNactivateCallback, f_cb, (XtPointer)0);
  mymenu.file.l_data=XtVaCreateManagedWidget("Load Data",
					     xmPushButtonGadgetClass, PullDown,
					     XmNmnemonic, 'L',
					     NULL);
  XtAddCallback(mymenu.file.l_data, XmNactivateCallback, f_cb, (XtPointer)1);
  mymenu.file.s_data=XtVaCreateManagedWidget("Save Data",
					     xmPushButtonGadgetClass, PullDown,
					     XmNmnemonic, 'S',
					     NULL);
  XtAddCallback(mymenu.file.s_data, XmNactivateCallback, f_cb, (XtPointer)2);
  XtVaCreateManagedWidget("separator", xmSeparatorGadgetClass, PullDown, NULL);
  mymenu.file.p_data=XtVaCreateManagedWidget("Print",
					     xmPushButtonGadgetClass, PullDown,
					     XmNmnemonic, 'P',
					     NULL);
  XtAddCallback(mymenu.file.p_data, XmNactivateCallback, f_cb, (XtPointer)3);
  XtVaCreateManagedWidget("separator", xmSeparatorGadgetClass, PullDown, NULL);
  mymenu.file.quit=XtVaCreateManagedWidget("Quit",
					   xmPushButtonGadgetClass, PullDown,
					   XmNmnemonic, 'Q',
					   NULL);
  XtAddCallback(mymenu.file.quit, XmNactivateCallback, f_cb, (XtPointer)4);

  /*   E d i t m e n u   */;
  PullDown=XmCreatePulldownMenu(menubar, "EditPullDown", NULL,0);
  mymenu.edit.e_menu=XtVaCreateManagedWidget("Edit",
					     xmCascadeButtonWidgetClass, menubar,
					     XmNlabelString, XmStringCreateLocalized("Edit"),
					     XmNmnemonic, 'E',
					     XmNsubMenuId, PullDown,
					     NULL);
  mymenu.edit.w_edit=XtVaCreateManagedWidget("Wert",
					     xmPushButtonGadgetClass, PullDown,
					     XmNmnemonic, 'W',
					     NULL);
  XtAddCallback(mymenu.edit.w_edit, XmNactivateCallback, e_cb, (XtPointer)0);
  mymenu.edit.c_edit=XtVaCreateManagedWidget("Clear Bestand",
					     xmPushButtonGadgetClass, PullDown,
					     XmNmnemonic, 'C',
					     NULL);
  XtAddCallback(mymenu.edit.c_edit, XmNactivateCallback, e_cb, (XtPointer)1);
  XtVaCreateManagedWidget("separator", xmSeparatorGadgetClass, PullDown, NULL);
  mymenu.edit.c_edit=XtVaCreateManagedWidget("Unselect Rows",
					     xmPushButtonGadgetClass, PullDown,
					     XmNmnemonic, 'U',
					     NULL);
  XtAddCallback(mymenu.edit.c_edit, XmNactivateCallback, e_cb, (XtPointer)2);

  /* Create a Matrix widget. */
  rows=10; columns=10;
  cells = (String **)XtMalloc(rows * sizeof(String *));
  rowArrays = (String *)XtMalloc(rows * columns * sizeof(String));
  for (i = 0; i < rows; i++) {
    cells[i] = &rowArrays[i * columns];
    for (j = 0; j < columns; j++) {
      rowArrays[i * columns + j] = (String) XtNewString(EMPTY);
    }
  }
  /* Column Width */
  colwidth=new short [columns];
  for (i=0; i<columns; i++) colwidth[i]=5;
  colwidth[0]=4;
  colwidth[1]=10;
  colwidth[2]=10;
  colwidth[3]=2;
  colwidth[4]=2;
  colwidth[5]=20;
  colwidth[6]=10;
  colwidth[7]=10;
  colwidth[8]=6;
  colwidth[9]=6;
  /* Column - Labels */
  clabels = (String *)XtMalloc(columns * sizeof(String));
  clabels[0]=(String) XtNewString("Jahr");
  clabels[1]=(String) XtNewString("PF-Nr.");
  clabels[2]=(String) XtNewString("Wert");
  clabels[3]=(String) XtNewString("*");
  clabels[4]=(String) XtNewString("@");
  clabels[5]=(String) XtNewString("Bezeichnung");
  clabels[6]=(String) XtNewString("Preis *");
  clabels[7]=(String) XtNewString("Preis @");
  clabels[8]=(String) XtNewString("Breite");
  clabels[9]=(String) XtNewString("Hhe");
  /* Row - Labels */
  rlabels=(String *)XtMalloc(rows * sizeof(String));
  for (i=0; i<rows; i++) {
    sprintf(mystr ,"%d", i+1);
    rlabels[i] = (String) XtNewString(mystr);
  }
  /* Widget */
  marken_w=XtVaCreateManagedWidget("mw",
				   xbaeMatrixWidgetClass, main_w,
				   XmNverticalScrollBarDisplayPolicy, XmDISPLAY_STATIC,
				   XmNselectScrollVisible, False,
				   XmNcolumns, columns,
				   XmNrows, rows,
				   XmNcolumnWidths, colwidth,
				   XmNcolumnLabels, clabels,
				   XmNrowLabels, rlabels,
				   XmNrowLabelWidth, 6,
				   XmNbuttonLabels, True,
				   XmNcells, cells,
				   NULL);
  XbaeMatrixDeleteRows(marken_w,0,rows);
  XtAddCallback(marken_w, XmNdefaultActionCallback, m_dc_cb, NULL);
  XtAddCallback(marken_w, XmNenterCellCallback, m_ec_cb, NULL);
  XtAddCallback(marken_w, XmNleaveCellCallback, m_lc_cb, NULL);
  XtAddCallback(marken_w, XmNlabelActivateCallback, m_la_cb, NULL);
  
  /* messagearea */
  message = XtVaCreateManagedWidget("message", xmLabelWidgetClass, main_w,
				    XmNalignment, XmALIGNMENT_BEGINNING,
				    XmNlabelString, XmStringCreateLocalized(" "),
				    NULL);
  XtVaSetValues(main_w, XmNmessageWindow, message, NULL);
  set_message(0,0);
  XtManageChild(menubar);
  XmMainWindowSetAreas(main_w, menubar, NULL, NULL, NULL, marken_w);

  XtSetSensitive(mymenu.file.n_data,False);
  XtSetSensitive(mymenu.file.s_data,False);
  XtSetSensitive(mymenu.file.p_data,False);

  /* Free memory */
  delete [] colwidth;
  for (i=0; i<columns; i++) XtFree(clabels[i]);
  for (i=0; i<rows; i++) XtFree(rlabels[i]);
  XtFree((char *) clabels);
  XtFree((char *) rlabels);
  XtFree((char *) rowArrays);
  XtFree((char *) cells);

  XtRealizeWidget(toplevel);
  XtAppMainLoop(app);
}

/* ------------------ */
/* Diverse Funktionen */
/* ------------------ */

void set_message(unsigned long nref, unsigned long nsel) {
  char   text[100];
  Widget top;

  sprintf(text,"   Number of stamps: total: %u, selected: %u      ", nref, nsel);
  XtVaSetValues(message,
		XmNlabelString, XmStringCreateLocalized(text),
		NULL);
  sprintf(text,TITLE" v"VERSION" %s", m.gebiet);
  top=marken_w;
  while (!XtIsTopLevelShell(top)) top=XtParent(top);
  XtVaSetValues(top, XmNtitle, text, NULL);
}

/* double click in matrix widget */
void m_dc_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  XbaeMatrixDefaultActionCallbackStruct *cst;
  String wert;
  char   h[256];

  cst=(XbaeMatrixDefaultActionCallbackStruct *) call_data;
  if (cst->column==3 || cst->column==4) {
    wert=XbaeMatrixGetCell(marken_w, cst->row, cst->column);
    strcpy(h,wert);
    if (!strcmp(h,"F")) {
      XbaeMatrixSetCell(marken_w, cst->row, cst->column, "T");
      if (cst->column==3) m.m[cst->row]->hi_pf=1;
      if (cst->column==4) m.m[cst->row]->hi_st=1;
    }
    if (!strcmp(h,"T")) {
      XbaeMatrixSetCell(marken_w, cst->row, cst->column, "F");
      if (cst->column==3) m.m[cst->row]->hi_pf=0;
      if (cst->column==4) m.m[cst->row]->hi_st=0;
    }
  }
}

/* enter cell in matrix widget */
void m_ec_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  XbaeMatrixEnterCellCallbackStruct *cst;

  cst=(XbaeMatrixEnterCellCallbackStruct *) call_data;
  if (cst->column==3 || cst->column==4) {
    cst->map=False;
    cst->doit=False;
  }
}

/* leave cell in matrix widget */
void m_lc_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  XbaeMatrixLeaveCellCallbackStruct *cst;
  char h[256];
  int  rc;

  cst=(XbaeMatrixLeaveCellCallbackStruct *) call_data;
  cst->doit=True;

  switch (cst->column) {
  case 0: // Jahr;
    m.m[cst->row]->jahr=(char *)realloc(m.m[cst->row]->jahr, strlen(cst->value)+1);
    strcpy(m.m[cst->row]->jahr,cst->value);
    break;
  case 1: // PFNr;
    m.m[cst->row]->minr=(char *)realloc(m.m[cst->row]->minr, strlen(cst->value)+1);
    strcpy(m.m[cst->row]->minr,cst->value);
    break;
  case 2: // Wert;
    m.m[cst->row]->wert=(char *)realloc(m.m[cst->row]->wert, strlen(cst->value)+1);
    strcpy(m.m[cst->row]->wert,cst->value);
    break;
  case 3: // have it pf;
    /* do nothing, handeled by double click */
    break;
  case 4: // have it st;
    /* do nothing, handeled by double click */
    break;
  case 5: // Titel;
    m.m[cst->row]->titel=(char *)realloc(m.m[cst->row]->titel, strlen(cst->value)+1);
    strcpy(m.m[cst->row]->titel,cst->value);
    break;
  case 6: // Preis pf;
    m.m[cst->row]->preis_pf=(float)strtod(cst->value, NULL);
    sprintf(h,"%.2f",m.m[cst->row]->preis_pf);
    cst->value=(String) realloc(cst->value, strlen(h)+1);
    strcpy(cst->value,h);
    break;
  case 7: // Preis st;
    m.m[cst->row]->preis_st=(float)strtod(cst->value, NULL);
    sprintf(h,"%.2f",m.m[cst->row]->preis_st);
    cst->value=(String) realloc(cst->value, strlen(h)+1);
    strcpy(cst->value,h);
    break;
  case 8: // Width;
    m.m[cst->row]->width=(float)strtod(cst->value, NULL);
    sprintf(h,"%.1f",m.m[cst->row]->width);
    cst->value=(String) realloc(cst->value, strlen(h)+1);
    strcpy(cst->value,h);
    break;
  case 9: // Height;
    m.m[cst->row]->height=(float)strtod(cst->value, NULL);
    sprintf(h,"%.1f",m.m[cst->row]->height);
    cst->value=(String) realloc(cst->value, strlen(h)+1);
    strcpy(cst->value,h);
    break;
  }
}

void m_la_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  XbaeMatrixLabelActivateCallbackStruct *cst;

  void set_message(unsigned long, unsigned long);

  cst=(XbaeMatrixLabelActivateCallbackStruct *) call_data;
  if (cst->row_label) { /* a row was activated */
    if (XbaeMatrixIsRowSelected(marken_w, cst->row)) {
      XbaeMatrixDeselectRow(marken_w, cst->row);
      nsel--;
    }
    else {
      XbaeMatrixSelectRow(marken_w, cst->row);
      nsel++;
    }
  }
  set_message(m.n, nsel);
}
