/* Program wert.cc        */
/* By Harald Stauss       */
/* Last change 12.03.2000 */

#define MAX_FIELD 50

#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <stdio.h>

main(int argc, char *argv[]) {
  float    version;
  float    wert_f, wert_s, wert;
  int      l_pos, tok_pos, n_tok, i;
  ifstream indat;
  ofstream outdat;
  char     *gebiet, h[1000];
  char     *linie, *f[MAX_FIELD], *tok;
  short    is_quote, n_header_items;

  /* initialization */
  linie =new char[1000];
  gebiet=new char[1000];
  tok   =new char[256];
  for (i=0; i<MAX_FIELD; i++) f[i]=new char[256];
  wert_f=0; wert_s=0;

  /* Hello World */
  cout << "wert Ver.0.3 by H. Stauss, 2000 \n";
  if (argc != 2) {
    cout << "Number of parameters wrong! \n";
    cout << "calculates value of collection \n";
    cout << "wert f_in \n";
    cout << "f_in  : name of input file (*.dat). \n";
    goto ende;
  }
  /* Eingabedatei oeffnen */
  indat.open(argv[1]);
  if (!indat) {
    cout << "Can't open file " << argv[1] << "\n";
    goto ende;
  }
  cout << "Input file   : " << argv[1] << "\n";

  /* header einlesen */
  n_header_items=0;
  while (n_header_items<2) {
    indat.getline(linie,1000);
    if (linie[0]!='%') {
      switch(n_header_items) {
      case 0:
	sscanf(linie,"%f",&version);
	break;
      case 1:
	strcpy(gebiet, linie);
	break;
      }
      n_header_items++;
    }
  }
  cout << "Briefmarken Ver.: " << version << " Sammelgebiet: " << gebiet << "\n";

  /*  M A I N L O O P  */
  while (!indat.eof()) {
    indat.getline(linie,1000);
    if ((linie[0]!='%') && (linie[0]!='\0')) {
      /* Blanks entfernen */
      is_quote=0;
      for (l_pos=0; l_pos<=strlen(linie); l_pos++) {
	if (linie[l_pos]=='"') 
	  if (is_quote) is_quote=0;
	  else is_quote=1;
	if (linie[l_pos]==' ' && !is_quote) {
	  strcpy(h,linie); h[l_pos]='\0';
	  strcat(h,(linie+l_pos+1));
	  strcpy(linie,h);
	  l_pos--;
	}
      }
      /* Get Tokens and put it in f[i] */
      n_tok=0; is_quote=0; tok_pos=0;
      for (l_pos=0; l_pos<=strlen(linie); l_pos++) {
	if(linie[l_pos]=='"') 
	  if (is_quote) is_quote=0;
	  else is_quote=1;
	if((linie[l_pos]==',') || (linie[l_pos]=='\0')) {
	  if(!is_quote) {
	    strncpy(tok,(linie+tok_pos),(l_pos-tok_pos));
	    tok[l_pos-tok_pos]='\0';
	    if(tok[0]=='"') {
	      strncpy(f[n_tok],tok+1,strlen(tok)-2);
	      f[n_tok][strlen(tok)-2]='\0';
	    }
	    else strcpy(f[n_tok],tok);
	    tok_pos=l_pos+1;
	    n_tok++;
	  }
	}
      }
      sscanf(f[6],"%f", &wert);
      if (strstr("true",f[3])) {
	wert_f+=wert;
      }
      sscanf(f[7],"%f", &wert);
      if (strstr("true",f[4])) {
	wert_s+=wert;
      }
    }
  } /* endwhile */
  indat.close();
  
  /* Ausgabe */
  cout << "Wert postfrisch: " << wert_f << "\n";
  cout << "Wert gestempelt: " << wert_s << "\n";

 ende: 
  delete[]linie;
  delete[]gebiet;
  delete[]tok;
  for (i=0; i<MAX_FIELD; i++) delete[]f[i];

  return(0);
} /* Ende von main */
