/* vordruck.h   */
/* LaTeX header */

static char latex_header[] = 
"\\documentclass[a4paper]{article}
\\usepackage{isolatin1}

% neue Werte fr Seitenabmessungen
\\setlength{\\topmargin}{-1cm}
\\setlength{\\textheight}{23cm}
\\setlength{\\oddsidemargin}{0mm}
\\setlength{\\evensidemargin}{0mm}
\\setlength{\\textwidth}{16cm}
\\setlength{\\parindent}{0cm}

%  #1:Jahr, #2:Nr, #3:Gre, #4:Wert, #5:Text

\\newcounter{x}
\\newcounter{y}
\\newcounter{MiNr}
\\newcounter{Breit}
\\newcounter{Hoehe}
\\newcounter{Links}
\\newcounter{Hoch}
\\newcounter{Abstand}

\\def\\marke#1/#2:#3, #4, #5*{%
#3%
\\setcounter{Breit}{\\value{x}}\\addtocounter{Breit}{-3}%
\\setcounter{Hoehe}{\\value{y}}\\addtocounter{Hoehe}{-3}%
\\setcounter{Links}{-\\value{x}}\\addtocounter{Links}{1}%
\\setcounter{Hoch}{2}%
\\unitlength=1mm
\\framebox(\\value{x},\\value{y})[lb]{\\strut}%
\\hsize     \\value{Breit}mm
\\kern \\value{Links}mm \\raise \\value{Hoch}mm
   \\hbox to \\value{Breit}mm {%
   \\vbox to \\value{Hoehe}mm
   {\\parbox{\\value{Breit}mm}{\\centering \\small\\strut #5\\par}%
    \\vskip 0pt plus 1 fill minus 1 fill
    \\parbox{\\value{Breit}mm}{\\centering \\Large\\strut #4\\par}%
    \\vskip 0pt plus 1 fill minus 1 fill
    %\\vfill
    \\parbox{\\value{Breit}mm}{\\centering \\small\\strut\\bf #1/#2\\par}%
   }}% vbox hbox
%\\hsize 195 mm % was originally
\\hsize \\textwidth % changed by H.St.
\\setcounter{Hoch}{\\value{y}}\\addtocounter{Hoch}{1}%
			     \\addtocounter{Hoch}{\\value{Abstand}}%
\\vrule width 0pt height \\value{Hoch}mm
\\hskip 1mm
\\hskip \\value{Abstand}mm
}% marke
\\def\\2{$\\frac{1}{2}$}
\\def\\3{$\\frac{1}{3}$}
\\def\\4{$\\frac{1}{4}$}

\\begin{document}
\\parindent=0pt
\\raggedright

\\def\\br{\\setcounter{x}{40}\\setcounter{y}{23}}% breites kleines Querformat
\\def\\sh{\\setcounter{x}{23}\\setcounter{y}{40}}% schmales kleines Hochformat
\\def\\qu{\\setcounter{x}{30}\\setcounter{y}{25}}% normales Querformat
\\def\\ho{\\setcounter{x}{25}\\setcounter{y}{30}}% normales Hochformat
\\def\\sm{\\setcounter{x}{19}\\setcounter{y}{23}}% Dauerserien kleines Hochformat
\\def\\sg{\\setcounter{x}{20}\\setcounter{y}{25}}% Dauerserien greres Hochformat
\\def\\gr{\\setcounter{x}{50}\\setcounter{y}{28}}% groes Querformat
\\def\\gh{\\setcounter{x}{28}\\setcounter{y}{50}}% groes Hochformat
\\def\\q2{\\setcounter{x}{32}\\setcounter{y}{32}}% groes Quadrat
\\def\\kq{\\setcounter{x}{20}\\setcounter{y}{20}}% kleines Quadrat (Altdeutsch)
\\def\\Nr{\\arabic{MiNr}\\addtocounter{MiNr}{1}}%
\\def\\jahr#1:#2-#3.{\\setcounter{MiNr}{#2}\\hskip 2mm\\marke #2/#3:\\br, #1, ~*\\strut\\\\[10mm]}%
\\def\\jahrx#1:#2-#3.{\\setcounter{MiNr}{#2}\\marke #2/#3:\\br, #1, ~*\\hskip 1mm}%

\\setcounter{Abstand}{0}

%-------------------------------
% Beispiel fr Jahresdefinition 
%\\jahr AD-Baden\\\\1851: 1-4.%
%-------------------------------
% Beispiel fr Markendefinition 
%       Jahr/Nr Gre                                  Wert   Text
%\\marke 1851/1a:\\setcounter{x}{24}\\setcounter{y}{24} , 1 Kr , Ziffernzeichnung*%
%
";

