/* Program vordruck.cc    */
/* By Harald Stauss       */
/* Last change 01.06.2000 */

/* --------------------------------------------------------------- */
/*   D a t e n b a n k     D e f i n i t i o n  (*.dat Dateien)    */
/* --------------------------------------------------------------- */
/* % Briefmarken Altdeutsch Baden                                  */
/* %                                                               */
/* % -----------------   h e a d e r   -------------------         */
/* % header:  Version, Sammelgebiet in jeweils einer neuen Linie   */
/* %                                                               */
/* 1.0                                                             */
/* Philatelie Baden                                                */
/* %                                                               */
/* % ----------------    D a t e n     -------------------         */
/* % Datenfelder durch Komma abgetrennt in einer Linie:            */
/* % 1.  Jahr                                                      */
/* % 2.  Mi-Nr.                                                    */
/* % 3.  Markenwert                                                */
/* % 4.  postfrisch vorhanden                                      */
/* % 5.  gestempelt vorhanden                                      */
/* % 6.  Titel der Marke                                           */
/* % 7.  Preis postfrisch                                          */
/* % 8.  Preis gestempelt                                          */
/* % 9.  Format Breite in mm                                       */
/* % 10. Format Hhe in mm                                         */
/* %                                                               */
/* --------------------------------------------------------------- */

#define MAX_FIELD 50

#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <stdio.h>

#include "vordruck.h"

main(int argc, char *argv[]) {
  float    version;
  float    wert_f, wert_s, wert;
  int      l_pos, tok_pos, n_tok, i, j;
  int      jahr_aktuell=-1, jahr_marke=-1;
  int      jahr_s=0, jahr_e=0; /* Michelnummer start ende fr Jahr */
  int      m_width, m_height;
  int      mi_nr1, mi_nr2;
  ifstream indat;
  ofstream outdat;
  char     *gebiet;
  char     *linie, *f[MAX_FIELD], *tok;
  char     **pmarks, h[1000];
  int      nmarks=0;
  short    is_quote, n_header_items;
  short    year_only=0, sel_marks=0, print_all=0;

  /* initialization */
  linie =new char[1000];
  gebiet=new char[1000];
  tok   =new char[256];
  for (i=0; i<MAX_FIELD; i++) f[i]=new char[256];
  wert_f=0; wert_s=0;

  /* Hello World */
  cout << "vordruck Ver.0.3 by H. Stauss, 2000 \n";
  if (argc < 3) {
    cout << "Number of parameters wrong! \n";
    cout << "creates LaTeX file \n";
    cout << "vordruck [options] f_in f_out \n";
    cout << "f_in  : name of input file (*.dat). \n";
    cout << "f_out : name of output file (*.ltx). \n";
    cout << "-j    : only marks for the years are generated. \n";
    cout << "-m Mi1 Mi2 Mi3 ...   : print only explicit marks. \n";
    goto ende;
  }

  /* Parameter (Optionen) einlesen */
  if (argc >3) {
    if (!strcmp(argv[1],"-j")) {
      year_only=1;
    }
    if (!strcmp(argv[1],"-m")) {
      sel_marks=1;
      pmarks=new (char *)[argc-4];
      for (i=0; i<(argc-4); i++) {
	pmarks[i]=new char[255];
	strcpy(pmarks[i],argv[i+2]);
      }
      /* Michelnummern sortieren */
      for (i=0; i<(argc-4); i++) {
	for (j=0; j<(argc-4-1); j++) {
	  sscanf(pmarks[j],"%d",&mi_nr1);
	  sscanf(pmarks[j+1],"%d",&mi_nr2);
	  if (mi_nr1>mi_nr2) {
	    strcpy(h,pmarks[j]);
	    strcpy(pmarks[j],pmarks[j+1]);
	    strcpy(pmarks[j+1],h);
	  }
	}
      }
    }
  }
  else print_all=1;

  /* Eingabedatei oeffnen */
  indat.open(argv[argc-2]);
  if (!indat) {
    cout << "Can't open file " << argv[argc-2] << "\n";
    goto ende;
  }
  cout << "Input file   : " << argv[argc-2] << "\n";

  /* Ausgabedatei oeffnen */
  outdat.open(argv[argc-1]);
  if (!outdat) {
    cout << "Can't open file " << argv[argc-1] << "\n";
    goto ende;
  }
  cout << "Output file  : " << argv[argc-1] << "\n";
  /* LaTeX header schreiben */
  outdat << latex_header;

  /* header einlesen */
  n_header_items=0;
  while (n_header_items<2) {
    indat.getline(linie,1000);
    if (linie[0]!='%') {
      switch(n_header_items) {
      case 0:
	sscanf(linie,"%f",&version);
	break;
      case 1:
	strcpy(gebiet, linie);
	break;
      }
      n_header_items++;
    }
  }
  cout << "Briefmarken Ver.: " << version << " Sammelgebiet: " << gebiet << "\n";

  /*  M A I N L O O P  */
  while (!indat.eof()) {
    indat.getline(linie,1000);
    if ((linie[0]!='%') && (linie[0]!='\0')) {
      /* Blanks entfernen */
      is_quote=0;
      for (l_pos=0; l_pos<=strlen(linie); l_pos++) {
	if (linie[l_pos]=='"') 
	  if (is_quote) is_quote=0;
	  else is_quote=1;
	if (linie[l_pos]==' ' && !is_quote) {
	  strcpy(h,linie); h[l_pos]='\0';
	  strcat(h,(linie+l_pos+1));
	  strcpy(linie,h);
	  l_pos--;
	}
      }
      /* Get Tokens and put it in f[i] */
      n_tok=0; is_quote=0; tok_pos=0;
      for (l_pos=0; l_pos<=strlen(linie); l_pos++) {
	if(linie[l_pos]=='"') 
	  if (is_quote) is_quote=0;
	  else is_quote=1;
	if((linie[l_pos]==',') || (linie[l_pos]=='\0')) {
	  if(!is_quote) {
	    strncpy(tok,(linie+tok_pos),(l_pos-tok_pos));
	    tok[l_pos-tok_pos]='\0';
	    if(tok[0]=='"') {
	      strncpy(f[n_tok],tok+1,strlen(tok)-2);
	      f[n_tok][strlen(tok)-2]='\0';
	    }
	    else strcpy(f[n_tok],tok);
	    tok_pos=l_pos+1;
	    n_tok++;
	  }
	}
      }
      /* Anfangsjahr setzen */
      sscanf(f[0], "%d", &jahr_marke);
      if (jahr_aktuell<0) {
	jahr_aktuell=jahr_marke;
	sscanf(f[1], "%d", &jahr_s);
      }
      /* ohne Options */
      if (print_all) {
	/* Jahresmarke drucken */
	if (jahr_aktuell!=jahr_marke) {
	  outdat << "\\jahr " << gebiet << "\\\\" << jahr_aktuell
		 << ": " << jahr_s << "-" << jahr_e << ".%\n";
	  jahr_aktuell=jahr_marke;
	  sscanf(f[1], "%d", &jahr_s);
	}
	/* Marke drucken */
	sscanf(f[8], "%d", &m_width);
	sscanf(f[9], "%d", &m_height);
	outdat << "\\marke " << f[0] << "/" << f[1] << ":";
	outdat << "\\setcounter{x}{" << m_width
	       << "}\\setcounter{y}{" << m_height << "} , ";
	outdat << f[2] << " , " << f[5] << "*%\n";
      } /* end print_all */
      /* nur Jahresmarken */
      if (year_only) {
	/* Jahresmarke drucken */
	if (jahr_aktuell!=jahr_marke) {
	  outdat << "\\jahrx " << gebiet << "\\\\" << jahr_aktuell
		 << ": " << jahr_s << "-" << jahr_e << ".%\n";
	  jahr_aktuell=jahr_marke;
	  sscanf(f[1], "%d", &jahr_s);
	}
      } /* end year_only */
      /* nur bestimmte Marken */
      if (sel_marks) {
	/* Marke drucken */
	if (!strncmp(f[1],pmarks[nmarks], strlen(pmarks[nmarks]))) {
	  sscanf(f[8], "%d", &m_width);
	  sscanf(f[9], "%d", &m_height);
	  outdat << "\\marke " << f[0] << "/" << f[1] << ":";
	  outdat << "\\setcounter{x}{" << m_width
		 << "}\\setcounter{y}{" << m_height << "} , ";
	  outdat << f[2] << " , " << f[5] << "*%\n";
	  if (nmarks < (argc-5)) nmarks++;
	}
      } /* end sel_marks */
      /* Setze jahr_e auf die aktuelle Marke */
      sscanf(f[1], "%d", &jahr_e);
    }
  } /* endwhile */

  /* letzte Jahresmarke drucken */
  if (print_all) {
    outdat << "\\jahr " << gebiet << "\\\\" << jahr_aktuell
	   << ": " << jahr_s << "-" << jahr_e << ".%\n";
  }
  if (year_only) {
    outdat << "\\jahrx " << gebiet << "\\\\" << jahr_aktuell
	   << ": " << jahr_s << "-" << jahr_e << ".%\n";
  }

  /* schliee Dateien */
  indat.close();
  outdat << "\\end{document} \n";
  outdat.close();
  
 ende: 
  delete[]linie;
  delete[]gebiet;
  delete[]tok;
  for (i=0; i<MAX_FIELD; i++) delete[]f[i];

  return(0);
} /* Ende von main */
