/*******************************************************/
/* Linux  GNU     C++ Compiler                         */
/* Name : marken.h                                     */
/* Autor: Harald Stauss                                */
/*******************************************************/

#ifndef STAMPS

#define STAMPS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>

#define NO_GEBIET "no database loaded"

class MARKEN {
  typedef struct {
    char   *jahr;		/* Jahr der Ausgabe */
    char   *minr;		/* PhilFree Nummer */
    char   *wert;               /* Wert auf Marke */
    short  hi_pf, hi_st;        /* Marke vorhanden postfrisch, gestempelt */
    char   *titel;		/* Bezeichnung der Marke */
    float  preis_pf, preis_st;  /* Preis postfrisch, gestempelt */
    float  width, height;       /* Format der Marke */
  }
  MARKE;

 public:
  float         version;        /* Version der Datenbank */
  unsigned long n;              /* Anzahl der Marken */
  char          *gebiet;        /* Sammelgebiet */
  MARKE         **m;	        /* Marken Struktur */

  // Initialisierung der Registrierung;
  MARKEN();   // Constructor;
  ~MARKEN();  // Destructor;

  /* Function to free Marken */
  int FreeSTAMP();

  // function to read *.dat files;
  int ReadDAT(char *fname);

  // function to write *.dat files;
  int WriteDAT(char *fname);
  
  /* function to add new stamp */
  int AddSTAMP();

  /* function to delete stamp */
  int DelSTAMP(unsigned long nm);

  /* function to get the value of the collection */
  int GetVALUE(float *w_pf, float *w_st);

  /* function to get the first year */
  int GetMinYEAR();

  /* function to get the last year */
  int GetMaxYEAR();

}; /* Ende der Klassendefinition */

#endif

