/*******************************************************/
/* Linux  GNU     C++ Compiler                         */
/* Name : marken.cc                                    */
/* Autor: Harald Stauss                                */
/*******************************************************/

#include "marken.h"
 
/* ----------------------------- */
/* Implementation der Funktionen */
/* ----------------------------- */

/* Constructor */
MARKEN::MARKEN() {
  n=0;
  gebiet=new char [256];
  strcpy(gebiet,NO_GEBIET);
  m='\0';
}

/* Destructor */
MARKEN::~MARKEN() {
  unsigned long ni;
  for (ni=n-1; ni==0; ni--) {
    delete [] m[ni]->jahr;
    delete [] m[ni]->minr;
    delete [] m[ni]->wert;
    delete [] m[ni]->titel;
    delete m[ni];
  }
  delete [] m;
  n=0;
  delete [] gebiet;
}

/* Funktion zum Lesen der Werte aus ASCII Format */
int MARKEN::ReadDAT(char *fname) {
  int      rc=0;
  ifstream indat;
  short    is_quote, n_header_items;
  int      l_pos, tok_pos, n_tok, i;
  char     *linie, *tok, *h;

  /* Initialization */
  linie =new char[1000];
  tok   =new char[256];
  h     =new char[1000];

  /* Eingabedatei oeffnen */
  indat.open(fname);
  if (!indat) {
    cout << "Can't open file " << fname << "\n";
    goto ende;
  }

  /* header einlesen */
  n_header_items=0;
  while (n_header_items<2) {
    indat.getline(linie,1000);
    if (linie[0]!='%') {
      switch(n_header_items) {
      case 0:
	sscanf(linie,"%f",&version);
	break;
      case 1:
	strcpy(gebiet, linie);
	break;
      }
      n_header_items++;
    }
  }

  /*  M A I N L O O P  */
  while (!indat.eof()) {
    indat.getline(linie,1000);
    if ((linie[0]!='%') && (linie[0]!='\0')) {
      /* Blanks entfernen */
      is_quote=0;
      for (l_pos=0; l_pos<=strlen(linie); l_pos++) {
	if (linie[l_pos]=='"') 
	  if (is_quote) is_quote=0;
	  else is_quote=1;
	if (linie[l_pos]==' ' && !is_quote) {
	  strcpy(h,linie); h[l_pos]='\0';
	  strcat(h,(linie+l_pos+1));
	  strcpy(linie,h);
	  l_pos--;
	}
      }
      AddSTAMP();
      /* Get Tokens and put it in struct */
      n_tok=0; is_quote=0; tok_pos=0;
      for (l_pos=0; l_pos<=strlen(linie); l_pos++) {
	if(linie[l_pos]=='"') 
	  if (is_quote) is_quote=0;
	  else is_quote=1;
	if((linie[l_pos]==',') || (linie[l_pos]=='\0')) {
	  if(!is_quote) {
	    strncpy(tok,(linie+tok_pos),(l_pos-tok_pos));
	    tok[l_pos-tok_pos]='\0';
	    if(tok[0]=='"') {
	      strncpy(h,tok+1,strlen(tok)-2);
	      h[strlen(tok)-2]='\0';
	    }
	    else strcpy(h,tok);
	    switch (n_tok) {
	    case 0:
	      if (!m[n-1]->jahr) {
		m[n-1]->jahr=new char [strlen(h)+1];
		strcpy(m[n-1]->jahr,h);
	      }
	      break;
	    case 1:
	      if (!m[n-1]->minr) {
		m[n-1]->minr=new char [strlen(h)+1];
		strcpy(m[n-1]->minr,h);
	      }
	      break;
	    case 2:
	      if (!m[n-1]->wert) {
		m[n-1]->wert=new char [strlen(h)+1];
		strcpy(m[n-1]->wert,h);
	      }
	      break;
	    case 3:
	      if (!strcasecmp(h,"true")) m[n-1]->hi_pf=1;
	      break;
	    case 4:
	      if (!strcasecmp(h,"true")) m[n-1]->hi_st=1;
	      break;
	    case 5:
	      if (!m[n-1]->titel) {
		m[n-1]->titel=new char [strlen(h)+1];
		strcpy(m[n-1]->titel,h);
	      }
	      break;
	    case 6:
	      sscanf(h,"%f",&m[n-1]->preis_pf);
	      break;
	    case 7:
	      sscanf(h,"%f",&m[n-1]->preis_st);
	      break;
	    case 8:
	      sscanf(h,"%f",&m[n-1]->width);
	      break;
	    case 9:
	      sscanf(h,"%f",&m[n-1]->height);
	      break;
	    }
	    tok_pos=l_pos+1;
	    n_tok++;
	  }
	}
      }
    }
  } /* endwhile */
  /* end of function */
  indat.close();
 ende:
  delete [] linie; delete [] tok; delete [] h;
  return(rc);
}

/*Funktion zum Schreiben der Werte auf ASCII Format */
int MARKEN::WriteDAT(char *fname) {
  ofstream      outdat;
  int           rc=0;
  unsigned long ni;
  char          h[256];

  /* Ausgabedatei oeffnen */
  outdat.open(fname);
  if (!outdat) {
    cout << "Can't open file " << fname << "\n";
    goto ende;
  }

  /* header schreiben */
  outdat << "% -----------------   h e a d e r   ------------------- \n";
  outdat << "% Kommentare: beginnen immer mit einem % Zeichen\n";
  outdat << "% header:     in jeweils einer neuen Linie\n";
  outdat << "%             Version des Datenbankformats\n";
  outdat << "%             Name des Sammelgebiets\n";
  outdat << "%\n";
  sprintf(h,"%.1f",version); /* Version des Datenbank-Formats */
  outdat << h << "\n";       /* Version des Datenbank-Formats */
  outdat << gebiet << "\n";  /* Sammelgebiet */
  outdat << "% \n";
  outdat << "% ----------------    D a t e n     ------------------- \n";
  outdat << "% Datenfelder werden durch Komma abgetrennt\n";
  outdat << "% und in einer Linie angeordnet.\n";
  outdat << "%\n";
  outdat << "% Einzelne Datenfelder knnen in Hochkomma >>> " << '"' << " <<<\n";
  outdat << "% eingeschlossen werden wenn z.B. im Text Kommas vorkommen\n";
  outdat << "%\n";
  outdat << "% Die Datenfelder sind:\n";
  outdat << "%\n";
  outdat << "% 1.  Jahr \n";
  outdat << "% 2.  Nummer der Briefmarke (gem PhilFree Nummerierung)\n";
  outdat << "% 3.  Markenwert  (der auf der Marke aufgedruckt ist)\n";
  outdat << "% 4.  postfrisch vorhanden (true/false)\n";
  outdat << "% 5.  gestempelt vorhanden (true/false)\n";
  outdat << "% 6.  Titel der Marke \n";
  outdat << "% 7.  Marktwert postfrisch \n";
  outdat << "% 8.  Marktwert gestempelt \n";
  outdat << "% 9.  Format Breite in mm \n";
  outdat << "% 10. Format Hhe in mm \n";
  outdat << "% \n";
  /* Werte schreiben */
  for (ni=0; ni<n; ni++) {
    outdat << '"' << m[ni]->jahr << '"' << ",";
    outdat << '"' << m[ni]->minr << '"' << ",";
    outdat << '"' << m[ni]->wert << '"' << ",";
    if (m[ni]->hi_pf==0) outdat << "false,";
    else outdat << "true,";
    if (m[ni]->hi_st==0) outdat << "false,";
    else outdat << "true,";
    outdat << '"' << m[ni]->titel << '"' << ",";
    sprintf(h,"%.2f",m[ni]->preis_pf);
    outdat << h << ",";
    sprintf(h,"%.2f",m[ni]->preis_st);
    outdat << h << ",";
    sprintf(h,"%.1f",m[ni]->width);
    outdat << h << ",";
    sprintf(h,"%.1f",m[ni]->height);
    outdat << h << "\n";
  }

  outdat.close();
 ende:
  return(rc);
}

/* Function to free Marken */
int MARKEN::FreeSTAMP() {
  int           rc=0;
  unsigned long ni;
  if (m)
    for(ni=n-1; ni>=1; ni--)
      DelSTAMP(ni);
  if (m && n==1) DelSTAMP(0);
  strcpy(gebiet,NO_GEBIET);
  return(rc);
}

/* Function to add new stamp */
int MARKEN::AddSTAMP() {
  if (!m) {
    n=1;
    m=new MARKE*[1];
    m[0]=new MARKE;
  }
  else {
    n++;
    m=(MARKE **)realloc(m, n*sizeof(MARKE*));
    m[n-1]=new MARKE;
  }
  if (!m) cout << "allocation failure *MARKE* ! \n";
  else {
    m[n-1]->jahr='\0';
    m[n-1]->minr='\0';
    m[n-1]->wert='\0';
    m[n-1]->hi_pf=0;
    m[n-1]->hi_st=0;
    m[n-1]->titel='\0';
    m[n-1]->preis_pf=0;
    m[n-1]->preis_st=0;
    m[n-1]->width=33;
    m[n-1]->height=33;
  }
}

/* function to delete stamp */
int MARKEN::DelSTAMP(unsigned long nm) {
  unsigned long ni;
  if(m && nm>=0 && nm<n) {
    if(m[nm]->jahr) delete[]m[nm]->jahr;
    if(m[nm]->minr) delete[]m[nm]->minr;
    if(m[nm]->wert) delete[]m[nm]->wert;
    if(m[nm]->titel) delete[]m[nm]->titel;
    delete m[nm];
    for(ni=nm; ni<n-1; ni++) {
      m[ni]=m[ni+1];
    }
    n--;
    if(n>0)
      m=(MARKE **)realloc(m,n*sizeof(MARKE*));
    else {
      delete[]m;
      m='\0';
    }
  }
}

/* function to get the value of the collection */
int MARKEN::GetVALUE(float *w_pf, float *w_st) {
  unsigned long ni;

  *w_pf=0; *w_st=0;
  for (ni=0; ni<n; ni++) {
    if(m[ni]->hi_pf) *w_pf+=m[ni]->preis_pf;
    if(m[ni]->hi_st) *w_st+=m[ni]->preis_st;
  }
}

/* function to get the first year */
int MARKEN::GetMinYEAR() {
  unsigned long ni;
  int           ymin=10000;

  for (ni=0; ni<n; ni++)
    if (ymin>(int)strtol(m[ni]->jahr, NULL, 10))
      ymin=(int)strtol(m[ni]->jahr, NULL,10);
  return(ymin);
}

/* function to get the last year */
int MARKEN::GetMaxYEAR() {
  unsigned long ni;
  int           ymax=0;

  for (ni=0; ni<n; ni++)
    if (ymax<(int)strtol(m[ni]->jahr, NULL, 10))
      ymax=(int)strtol(m[ni]->jahr, NULL,10);
  return(ymax);
}
