/* Program makedb.cc      */
/* By Harald Stauss       */
/* Last change 12.03.2000 */

#define MAX_FIELD 50

#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <stdio.h>

main(int argc, char *argv[]) {
  float    version;
  int      l_pos, tok_pos, n_tok, i, haveit;
  ifstream indat;
  ofstream csvdat, ifodat;
  char     *fname, *csvname, *ifoname;
  char     *gebiet, *hh, h[1000];
  char     *linie, *f[MAX_FIELD], *tok;
  short    is_quote, n_header_items;

  /* initialization */
  haveit=1;
  linie  =new char[1000];
  gebiet =new char[1000];
  fname  =new char[256];
  csvname=new char[256];
  ifoname=new char[256];
  tok    =new char[256];
  for (i=0; i<MAX_FIELD; i++) f[i]=new char[256];

  /* Hello World */
  cout << "makedb Ver.0.3 by H. Stauss, 2000 \n";
  if ((argc!=2) && (argc!=3)) {
    cout << "Number of parameters wrong! \n";
    cout << "creates CSV and IFO file for use by csv2pdb \n";
    cout << "makedb f_in [haveit] \n";
    cout << "f_in  : name of input file (*.dat). \n";
    cout << "haveit: 0: zero; 1: keep \"vorhanden\" fields\n";
    goto ende;
  }
  if (argc==3) sscanf(argv[2],"%d",&haveit);

  /* get filename */
  strcpy(fname,argv[1]);
  hh=strrchr(fname,'.'); hh[0]='\0';
  strcpy(csvname,fname); strcat(csvname,".csv\0");
  strcpy(ifoname,fname); strcat(ifoname,".ifo\0");
  /* Eingabedatei oeffnen */
  indat.open(argv[1]);
  if (!indat) {
    cout << "Can't open file " << argv[1] << "\n";
    goto ende;
  }
  /* Ausgabedateien oeffnen */
  csvdat.open(csvname);
  if (!csvdat) {
    cout << "Can't open file " << csvname << "\n";
    goto ende;
  }
  ifodat.open(ifoname);
  if (!ifodat) {
    cout << "Can't open file " << ifoname << "\n";
    goto ende;
  }
  cout << "DAT file: " << argv[1] << "\n";
  cout << "CSV file: " << csvname << "\n";
  cout << "IFO file: " << ifoname << "\n";

  /* header einlesen */
  n_header_items=0;
  while (n_header_items<2) {
    indat.getline(linie,1000);
    if (linie[0]!='%') {
      switch(n_header_items) {
      case 0:
	sscanf(linie,"%f",&version);
	break;
      case 1:
	strcpy(gebiet, linie);
	break;
      }
      n_header_items++;
    }
  }
  cout << "Sammelgebiet: " << gebiet << " Version: " << version << "\n";

  /*  M A I N L O O P  */
  while (!indat.eof()) {
    indat.getline(linie,1000);
    if ((linie[0]!='%') && (linie[0]!='\0')) {
      /* Blanks entfernen */
      is_quote=0;
      for (l_pos=0; l_pos<=strlen(linie); l_pos++) {
	if (linie[l_pos]=='"') 
	  if (is_quote) is_quote=0;
	  else is_quote=1;
	if (linie[l_pos]==' ' && !is_quote) {
	  strcpy(h,linie); h[l_pos]='\0';
	  strcat(h,(linie+l_pos+1));
	  strcpy(linie,h);
	  l_pos--;
	}
      }
      /* Get Tokens and put it in f[i] */
      n_tok=0; is_quote=0; tok_pos=0;
      for (l_pos=0; l_pos<=strlen(linie); l_pos++) {
	if(linie[l_pos]=='"') 
	  if (is_quote) is_quote=0;
	  else is_quote=1;
	if((linie[l_pos]==',') || (linie[l_pos]=='\0')) {
	  if(!is_quote) {
	    strncpy(tok,(linie+tok_pos),(l_pos-tok_pos));
	    tok[l_pos-tok_pos]='\0';
	    if(tok[0]=='"') {
	      strncpy(f[n_tok],tok+1,strlen(tok)-2);
	      f[n_tok][strlen(tok)-2]='\0';
	    }
	    else strcpy(f[n_tok],tok);
	    tok_pos=l_pos+1;
	    n_tok++;
	  }
	}
      }
      csvdat << f[0] << ",\"" << f[1] << "\",\"" << f[2] << "\",";
      if (haveit) csvdat << f[3] << "," << f[4] << ",\"";
      else        csvdat << "false,false,\"";
      csvdat << f[5] << "\",\"" << f[6] << "\",\"" << f[7] << "\",\"";
      csvdat << f[8] << "\",\"" << f[9] << "\"\n";
    }
  } /* endwhile */

  /* IFO file */
  ifodat << "title \"" << gebiet << "\"\n";
  ifodat << "field \"Jahr\" integer 25 \n";
  ifodat << "field \"Mi\" string 25 \n";
  ifodat << "field \"Wert\" string 35 \n";
  ifodat << "field \"*\" boolean 20 \n";
  ifodat << "field \"@\" boolean 20 \n";
  ifodat << "field \"Thema\" string 80 \n";
  ifodat << "field \"Wert*\" string 40 \n";
  ifodat << "field \"Wert@\" string 40 \n";
  ifodat << "field \"Breite\" string 30 \n";
  ifodat << "field \"Hoehe\" string 30 \n";
  ifodat << "backup on\n";
  ifodat << "find on\n";
  ifodat << "extended on\n";

  /* close files */
  indat.close(); csvdat.close(); ifodat.close();

 ende: 
  delete[]linie;
  delete[]gebiet;
  delete[]fname;
  delete[]csvname;
  delete[]ifoname;
  delete[]tok;
  for (i=0; i<MAX_FIELD; i++) delete[]f[i];
  return(0);

} /* Ende von main */
