#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleBG.h>
#include <Xm/Text.h>
#include <X11/cursorfont.h>
#include <linux/errno.h>
#include "global.h"
#include "vordruck.h"

void f_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  unsigned long n;
  int           i, item, nrows, mrow, mcol;
  char          *c_year;
  static Widget fsb_ld, fsb_sd;
  static Widget dialog, form, radio_box;
  static Widget but1_w, but2_w, but3_w, but4_w, year_w;
  Arg    args[5];

  void ld_cb(Widget, XtPointer, XtPointer);
  void sd_cb(Widget, XtPointer, XtPointer);
  void fsb_cancel(Widget, XtPointer, XtPointer);
  void radio_but_cb(Widget w, XtPointer client_data, XtPointer call_data);
  void year_w_cb(Widget w, XtPointer client_data, XtPointer call_data);
  void print_ok_cb(Widget w, XtPointer client_data, XtPointer call_data);
  extern void set_message(unsigned long, unsigned long);

  item=(int) client_data;

  switch(item) {
  case 0:      // new;
    /* free Marken */
    m.FreeSTAMP();
    XtVaGetValues(marken_w, XmNrows, &nrows, NULL);
    XbaeMatrixDeleteRows(marken_w,0,nrows);
    set_message(m.n, nsel);
    /* set menuitems */
    XtSetSensitive(mymenu.file.n_data,False);
    XtSetSensitive(mymenu.file.s_data,False);
    XtSetSensitive(mymenu.file.l_data,True);
    XtSetSensitive(mymenu.file.p_data,False);
    break;
  case 1:      // load data;
    if (!fsb_ld) {
      fsb_ld=XmCreateFileSelectionDialog(marken_w, "filesb", NULL, 0);
      XtVaSetValues(XtParent(fsb_ld),
		    XmNtitle, "Load Data",
		    NULL);
      XtAddCallback(fsb_ld,XmNokCallback, ld_cb, NULL);
      XtAddCallback(fsb_ld,XmNcancelCallback, fsb_cancel, NULL);
    }
    XtManageChild(fsb_ld);
    break;
  case 2:      // save data;
    if (!fsb_sd) {
      fsb_sd=XmCreateFileSelectionDialog(marken_w, "filesb", NULL, 0);
      XtVaSetValues(XtParent(fsb_sd),
		    XmNtitle, "Save Data",
		    NULL);
      XtAddCallback(fsb_sd,XmNokCallback, sd_cb, NULL);
      XtAddCallback(fsb_sd,XmNcancelCallback, fsb_cancel, NULL);
    }
    XtManageChild(fsb_sd);
    break;
  case 3:      // print;
    /* create dialog */
    i=0;
    XtSetArg(args[i], XmNdialogTitle,
	     XmStringCreateLocalized("print stamps"));
    i++;
    XtSetArg(args[i], XmNmessageString,
	     XmStringCreateLocalized("tell me what to print:"));
    i++;
    XtSetArg(args[i], XmNautoUnmanage, False); i++;
    dialog=XmCreateMessageDialog(toplevel, "dialog", args, i);
    XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
    form=XtVaCreateWidget("form", xmFormWidgetClass, dialog, NULL);
    /* create Radiobox */
    radio_box=XmCreateRadioBox(form, "radio_box", NULL, 0);
    but1_w=XtVaCreateManagedWidget("All of the year:",xmToggleButtonGadgetClass, radio_box,
				   NULL);
    XtAddCallback(but1_w, XmNvalueChangedCallback, radio_but_cb, (XtPointer)1);
    but2_w=XtVaCreateManagedWidget("Selected stamps",xmToggleButtonGadgetClass, radio_box,
				   NULL);
    XtAddCallback(but2_w, XmNvalueChangedCallback, radio_but_cb, (XtPointer)2);
    but3_w=XtVaCreateManagedWidget("All stamps",xmToggleButtonGadgetClass, radio_box,
				   NULL);
    XtAddCallback(but3_w, XmNvalueChangedCallback, radio_but_cb, (XtPointer)3);
    but4_w=XtVaCreateManagedWidget("Year tags only",xmToggleButtonGadgetClass, radio_box,
				   NULL);
    XtAddCallback(but4_w, XmNvalueChangedCallback, radio_but_cb, (XtPointer)4);
    switch (print_s.what) {
    case 1:     // all from a year;
      XtVaSetValues(but1_w, XmNset, True, NULL);
      break;
    case 2:     // selected stamps;
      XtVaSetValues(but2_w, XmNset, True, NULL);
      break;
    case 3:     // all stamps;
      XtVaSetValues(but3_w, XmNset, True, NULL);
      break;
    case 4:     // year tags only;
      XtVaSetValues(but4_w, XmNset, True, NULL);
      break;
    }
    year_w=XtVaCreateManagedWidget("Which year: ", xmTextWidgetClass, form,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, radio_box,
				   NULL);
    XtAddCallback(year_w, XmNvalueChangedCallback, year_w_cb, NULL);
    XbaeMatrixGetCurrentCell(marken_w, &mrow, &mcol);
    c_year=XbaeMatrixGetCell(marken_w, mrow, 0);
    XmTextSetString(year_w, c_year);
    /* manage everything */
    XtManageChild(form);
    XtManageChild(radio_box);
    XtManageChild(dialog);
    XtAddCallback(dialog, XmNokCallback, print_ok_cb, NULL);
    XtAddCallback(dialog, XmNcancelCallback, fsb_cancel, NULL);
    XtPopup(XtParent(dialog), XtGrabNone);
    break;
  case 4:      // quit;
    exit(0);
    break;
  }
}

/* ..................................*/
/* .....   C a l l b a c k s   ..... */
/* ................................. */
void fsb_cancel(Widget widget, XtPointer client_data, XtPointer call_data) {
  XtUnmanageChild(widget);
}

void ld_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  char          *filename, h[256];
  Cursor        uhr, pfeil;
  int           nrows, nr;
  String        *rlabels;
  
  extern void set_message(unsigned long, unsigned long);

  /* get filename */
  XmFileSelectionBoxCallbackStruct *cbs=
    (XmFileSelectionBoxCallbackStruct *) call_data;
  if (!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &filename)) {
    cout << "Internal error pasting filename! \n";
    return;
  }
  if (!*filename) {
    cout << "No file selected! \n";
    XtFree(filename);
    return;
  }

  uhr  =XCreateFontCursor(XtDisplay(widget),XC_watch);
  pfeil=XCreateFontCursor(XtDisplay(widget), XC_arrow);

  XDefineCursor(XtDisplay(widget),XtWindow(widget),uhr);
  XFlush(XtDisplay(widget));

  m.ReadDAT(filename);
  /* Fill Matrix Tabel */
  XtVaGetValues(marken_w, XmNrows, &nrows, NULL);
  rlabels=(String *)XtMalloc(m.n * sizeof(String));
  if (nrows<m.n)
    XbaeMatrixAddRows(marken_w,nrows,NULL,NULL,NULL,m.n-nrows);
  for (nr=0; nr<m.n; nr++) {
    XbaeMatrixSetCell(marken_w, nr, 0, m.m[nr]->jahr);
    XbaeMatrixSetCell(marken_w, nr, 1, m.m[nr]->minr);
    XbaeMatrixSetCell(marken_w, nr, 2, m.m[nr]->wert);
    if (m.m[nr]->hi_pf) strcpy(h,"T");
    else strcpy(h,"F");
    XbaeMatrixSetCell(marken_w, nr, 3, h);
    if (m.m[nr]->hi_st) strcpy(h,"T");
    else strcpy(h,"F");
    XbaeMatrixSetCell(marken_w, nr, 4, h);
    XbaeMatrixSetCell(marken_w, nr, 5, m.m[nr]->titel);
    sprintf(h,"%.2f",m.m[nr]->preis_pf);
    XbaeMatrixSetCell(marken_w, nr, 6, h);
    sprintf(h,"%.2f",m.m[nr]->preis_st);
    XbaeMatrixSetCell(marken_w, nr, 7, h);
    sprintf(h,"%.1f",m.m[nr]->width);
    XbaeMatrixSetCell(marken_w, nr, 8, h);
    sprintf(h,"%.1f",m.m[nr]->height);
    XbaeMatrixSetCell(marken_w, nr, 9, h);
    /* Row - Labels */
    sprintf(h ,"%d", nr+1);
    rlabels[nr] = (String) XtNewString(h);
  }
  XtVaSetValues(marken_w, XmNrowLabels, rlabels, NULL);
  
  set_message(m.n, nsel);

  XtSetSensitive(mymenu.file.n_data,True);
  XtSetSensitive(mymenu.file.s_data,True);
  XtSetSensitive(mymenu.file.p_data,True);
  XtSetSensitive(mymenu.file.l_data,False);

  for (nr=0; nr<m.n; nr++) XtFree(rlabels[nr]);
  XtFree((char *) rlabels);
  XtFree(filename);
  XDefineCursor(XtDisplay(widget),XtWindow(widget),pfeil);
  XtUnmanageChild(widget);
  XFreeCursor(XtDisplay(widget), pfeil);
  XFreeCursor(XtDisplay(widget), uhr);
  return;
}

void sd_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  int           n;
  Arg           args[5];
  static Widget fexist;
  char          *filename;
  ofstream      dat;
  extern int    errno;
  void write_data(Widget, XtPointer, XtPointer);

  /* get filename */
  XmFileSelectionBoxCallbackStruct *cbs= 
    (XmFileSelectionBoxCallbackStruct *) call_data;
  if (!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &filename)) {
    cout << "Internal error pasting filename! \n";
    return;
  }
  if (!*filename) {
    cout << "No file selected! \n";
    XtFree(filename);
    return;
  }

  /* check whether file exists */
  dat.open(filename, ios::noreplace);
  if (errno==EEXIST) {
    if (!fexist) {
      n=0;
      XtSetArg(args[n], XmNmessageString, XmStringCreateLtoR("File already exists.\n     Overwrite?",XmFONTLIST_DEFAULT_TAG)); n++;
      XtSetArg(args[n], XmNokLabelString, XmStringCreateLocalized(" Yes ")); n++;
      XtSetArg(args[n], XmNcancelLabelString, XmStringCreateLocalized(" No ")); n++;
      XtSetArg(args[n], XmNtitle, "Save Data"); n++;
      fexist=XmCreateQuestionDialog(marken_w, "fexist", args, n);
      XtAddCallback(fexist, XmNokCallback, write_data, widget);
      XtUnmanageChild(XmMessageBoxGetChild(fexist, XmDIALOG_HELP_BUTTON));
    }
    XtManageChild(fexist);
    XtPopup(XtParent(fexist), XtGrabNone);
  }
  if (dat) {
    dat.close();
    write_data(NULL, widget, NULL);
  }

  XtFree(filename);
  return;
}

void write_data(Widget w, XtPointer client_data, XtPointer call_data) {
  Cursor        uhr, pfeil;
  Widget        fsb_sd;
  XmString      fname;
  char          *filename;

  /* initialize */
  fsb_sd=(Widget)client_data;
  uhr  =XCreateFontCursor(XtDisplay(fsb_sd), XC_watch);
  pfeil=XCreateFontCursor(XtDisplay(fsb_sd), XC_arrow);
  XDefineCursor(XtDisplay(fsb_sd),XtWindow(fsb_sd),uhr);
  XFlush(XtDisplay(fsb_sd));
  /* get filename */
  XtVaGetValues(fsb_sd, XmNdirSpec, &fname, NULL);
  XmStringGetLtoR(fname, XmFONTLIST_DEFAULT_TAG, &filename);
  /* write data */
  m.WriteDAT(filename);
  /* clean up */
  XDefineCursor(XtDisplay(fsb_sd),XtWindow(fsb_sd),pfeil);
  XFlush(XtDisplay(fsb_sd));
  XtUnmanageChild(fsb_sd);
  XmStringFree(fname);
  XtFree(filename);
  XFreeCursor(XtDisplay(fsb_sd), pfeil);
  XFreeCursor(XtDisplay(fsb_sd), uhr);
}

void radio_but_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  print_s.what=(short) client_data;
}

void year_w_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  char *gy;
  gy=XmTextGetString(w);
  print_s.year=(int)strtol(gy, NULL, 10);
  XtFree(gy);
}

void print_ok_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  static Widget fsb_print;

  void write_latex_cb(Widget w, XtPointer client_data, XtPointer call_data);
  extern void showmess(Widget widget, char *title, char *text);

  /* control if year is ok */
  if (print_s.what!=1 || (print_s.year <= m.GetMaxYEAR() && print_s.year >= m.GetMinYEAR())) {
    /* everything is ok now popup a FileDialog */
    XtUnmanageChild(w);
    if (!fsb_print) {
      fsb_print=XmCreateFileSelectionDialog(marken_w, "filesb", NULL, 0);
      XtVaSetValues(XtParent(fsb_print),
		    XmNtitle, "Save as LaTeX file",
		    NULL);
      XtAddCallback(fsb_print,XmNokCallback, write_latex_cb, NULL);
      XtAddCallback(fsb_print,XmNcancelCallback, fsb_cancel, NULL);
    }
    XtManageChild(fsb_print);
  }
  else {
    /* year is not correct */
    showmess(w, "Wrong Year", "There are no stamps in that year!");
  }
}

/* function to write LaTeX file */
void write_latex_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  int           n;
  Arg           args[5];
  static Widget fexist;
  char          *filename;
  ofstream      dat;
  extern int    errno;

  void write_latex_file(Widget, XtPointer, XtPointer);

  /* get filename */
  XmFileSelectionBoxCallbackStruct *cbs= 
    (XmFileSelectionBoxCallbackStruct *) call_data;
  if (!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &filename)) {
    cout << "Internal error pasting filename! \n";
    return;
  }
  if (!*filename) {
    cout << "No file selected! \n";
    XtFree(filename);
    return;
  }

  /* check whether file exists */
  dat.open(filename, ios::noreplace);
  if (errno==EEXIST) {
    if (!fexist) {
      n=0;
      XtSetArg(args[n], XmNmessageString, XmStringCreateLtoR("File already exists.\n     Overwrite?",XmFONTLIST_DEFAULT_TAG)); n++;
      XtSetArg(args[n], XmNokLabelString, XmStringCreateLocalized(" Yes ")); n++;
      XtSetArg(args[n], XmNcancelLabelString, XmStringCreateLocalized(" No ")); n++;
      XtSetArg(args[n], XmNtitle, "Save as LaTeX file"); n++;
      fexist=XmCreateQuestionDialog(marken_w, "fexist", args, n);
      XtAddCallback(fexist, XmNokCallback, write_latex_file, w);
      XtUnmanageChild(XmMessageBoxGetChild(fexist, XmDIALOG_HELP_BUTTON));
    }
    XtManageChild(fexist);
    XtPopup(XtParent(fexist), XtGrabNone);
  }
  if (dat) {
    dat.close();
    write_latex_file(NULL, w, NULL);
  }

  XtFree(filename);
  return;
}

void write_latex_file(Widget w, XtPointer client_data, XtPointer call_data) {
  Widget        fsb_print;
  Cursor        uhr, pfeil;
  XmString      fname;
  char          *filename;
  ofstream      outdat;
  unsigned long ni;
  int      jahr_aktuell=-1, jahr_marke=-1;
  int      jahr_s=0, jahr_e=0; /* Michelnummer start ende fr Jahr */

  extern void showmess(Widget widget, char *title, char *text);

  /* initialize */
  fsb_print=(Widget)client_data;
  uhr  =XCreateFontCursor(XtDisplay(fsb_print), XC_watch);
  pfeil=XCreateFontCursor(XtDisplay(fsb_print), XC_arrow);
  XDefineCursor(XtDisplay(fsb_print),XtWindow(fsb_print),uhr);
  XFlush(XtDisplay(fsb_print));
  /* get filename */
  XtVaGetValues(fsb_print, XmNdirSpec, &fname, NULL);
  XmStringGetLtoR(fname, XmFONTLIST_DEFAULT_TAG, &filename);

  /* write LaTeX file */
  /* Ausgabedatei oeffnen */
  outdat.open(filename);
  if (!outdat) {
    cout << "Can't open file " << filename << "\n";
    goto ende;
  }
  /* LaTeX header schreiben */
  outdat << latex_header;

  switch(print_s.what) {
  case 1: // all of a year;
    /* Anfangsjahr setzen */
    sscanf(m.m[0]->jahr, "%d", &jahr_marke);
    if (jahr_aktuell<0) {
      jahr_aktuell=jahr_marke;
      sscanf(m.m[0]->minr, "%d", &jahr_s);
    }
    for (ni=0; ni<m.n; ni++) {
      sscanf(m.m[ni]->jahr, "%d", &jahr_marke);
      if (jahr_marke==print_s.year) {
	/* Jahresmarke drucken */
	if (jahr_aktuell!=jahr_marke) {
	  jahr_aktuell=jahr_marke;
	  sscanf(m.m[ni]->minr, "%d", &jahr_s);
	}
	/* Marke drucken */
	outdat << "\\marke " << m.m[ni]->jahr << "/" << m.m[ni]->minr << ":";
	outdat << "\\setcounter{x}{" << (int)m.m[ni]->width
	       << "}\\setcounter{y}{" << (int)m.m[ni]->height << "} , ";
	outdat << m.m[ni]->wert << " , " << m.m[ni]->titel << "*%\n";
	/* Setze jahr_e auf die aktuelle Marke */
	sscanf(m.m[ni]->minr, "%d", &jahr_e);
      }
    } /* endfor */
    /* letzte Jahresmarke drucken */
    outdat << "\\jahr " << m.gebiet << "\\\\" << jahr_aktuell
	   << ": " << jahr_s << "-" << jahr_e << ".%\n";
    break;
  case 2: // selected stamps;
    /* Anfangsjahr setzen */
    sscanf(m.m[0]->jahr, "%d", &jahr_marke);
    if (jahr_aktuell<0) {
      jahr_aktuell=jahr_marke;
      sscanf(m.m[0]->minr, "%d", &jahr_s);
    }
    for (ni=0; ni<m.n; ni++) {
      sscanf(m.m[ni]->jahr, "%d", &jahr_marke);
      /* Jahresmarke drucken */
      if (jahr_aktuell!=jahr_marke) {
	jahr_aktuell=jahr_marke;
	sscanf(m.m[ni]->minr, "%d", &jahr_s);
      }
      /* Marke drucken */
      if (XbaeMatrixIsRowSelected(marken_w, ni)) {
	outdat << "\\marke " << m.m[ni]->jahr << "/" << m.m[ni]->minr << ":";
	outdat << "\\setcounter{x}{" << (int)m.m[ni]->width
	       << "}\\setcounter{y}{" << (int)m.m[ni]->height << "} , ";
	outdat << m.m[ni]->wert << " , " << m.m[ni]->titel << "*%\n";
      }
      /* Setze jahr_e auf die aktuelle Marke */
      sscanf(m.m[ni]->minr, "%d", &jahr_e);
    } /* endfor */
    break;
  case 3: // all stamps;
    /* Anfangsjahr setzen */
    sscanf(m.m[0]->jahr, "%d", &jahr_marke);
    if (jahr_aktuell<0) {
      jahr_aktuell=jahr_marke;
      sscanf(m.m[0]->minr, "%d", &jahr_s);
    }
    for (ni=0; ni<m.n; ni++) {
      sscanf(m.m[ni]->jahr, "%d", &jahr_marke);
      /* Jahresmarke drucken */
      if (jahr_aktuell!=jahr_marke) {
	outdat << "\\jahr " << m.gebiet << "\\\\" << jahr_aktuell
	       << ": " << jahr_s << "-" << jahr_e << ".%\n";
	jahr_aktuell=jahr_marke;
	sscanf(m.m[ni]->minr, "%d", &jahr_s);
      }
      /* Marke drucken */
      outdat << "\\marke " << m.m[ni]->jahr << "/" << m.m[ni]->minr << ":";
      outdat << "\\setcounter{x}{" << (int)m.m[ni]->width
	     << "}\\setcounter{y}{" << (int)m.m[ni]->height << "} , ";
      outdat << m.m[ni]->wert << " , " << m.m[ni]->titel << "*%\n";
      /* Setze jahr_e auf die aktuelle Marke */
      sscanf(m.m[ni]->minr, "%d", &jahr_e);
    } /* endfor */
    /* letzte Jahresmarke drucken */
    outdat << "\\jahr " << m.gebiet << "\\\\" << jahr_aktuell
	   << ": " << jahr_s << "-" << jahr_e << ".%\n";
    break;
  case 4: // year tags only;
    /* Anfangsjahr setzen */
    sscanf(m.m[0]->jahr, "%d", &jahr_marke);
    if (jahr_aktuell<0) {
      jahr_aktuell=jahr_marke;
      sscanf(m.m[0]->minr, "%d", &jahr_s);
    }
    for (ni=0; ni<m.n; ni++) {
      sscanf(m.m[ni]->jahr, "%d", &jahr_marke);
      if (jahr_aktuell!=jahr_marke) {
	outdat << "\\jahrx " << m.gebiet << "\\\\" << jahr_aktuell
	       << ": " << jahr_s << "-" << jahr_e << ".%\n";
	jahr_aktuell=jahr_marke;
	sscanf(m.m[ni]->minr, "%d", &jahr_s);
      }
      sscanf(m.m[ni]->minr, "%d", &jahr_e);
    }
    /* letzte Jahresmarke drucken */
    outdat << "\\jahrx " << m.gebiet << "\\\\" << jahr_aktuell
	   << ": " << jahr_s << "-" << jahr_e << ".%\n";
    break;
  }

  /* schliee Dateien */
  outdat << "\\end{document} \n";
  outdat.close();

ende:
  /* clean up */
  XDefineCursor(XtDisplay(fsb_print),XtWindow(fsb_print),pfeil);
  XFlush(XtDisplay(fsb_print));
  XtUnmanageChild(fsb_print);
  XmStringFree(fname);
  XtFree(filename);
  XFreeCursor(XtDisplay(fsb_print), pfeil);
  XFreeCursor(XtDisplay(fsb_print), uhr);
}
