/* Program tok.cc         */
/* By Harald Stauss       */
/* Last change 11.03.2000 */

#define MAX_FIELD 50

#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <stdio.h>

main(int argc, char *argv[]) {
  float    version;
  int      l_pos, tok_pos, n_tok, i;
  ifstream indat;
  ofstream outdat;
  char     *gebiet;
  char     *linie, *f[MAX_FIELD], *tok;
  short    is_quote, n_header_items;

  /* Hello World */
  cout << "TOK Ver.1.0 by H. Stauss, 2000 \n";
  if (argc != 3)
    {
      cout << "Number of parameters wrong! \n";
      cout << "read in CSV file \n";
      cout << "tok f_in f_out \n";
      cout << "f_in  : name of input file. \n";
      cout << "f_out : name of output file. \n";
      goto ende;
    }

  /* initialization */
  linie =new char[1000];
  gebiet=new char[1000];
  tok   =new char[256];
  for (i=0; i<MAX_FIELD; i++) f[i]=new char[256];
  /* Eingabedatei oeffnen */
  indat.open(argv[1]);
  if (!indat) {
    cout << "Can't open file " << argv[1] << "\n";
    goto ende;
  }
  /* Ausgabedatei oeffnen */
  outdat.open(argv[2]);
  if (!outdat) {
    cout << "Can't open file " << argv[2] << "\n";
    goto ende;
  }
  cout << "Input file   : " << argv[1] << "\n";
  cout << "Output file  : " << argv[2] << "\n";

  /* header einlesen */
  n_header_items=0;
  while (n_header_items<2) {
    indat.getline(linie,1000);
    if (linie[0]!='%') {
      switch(n_header_items) {
      case 0:
	sscanf(linie,"%f",&version);
	break;
      case 1:
	strcpy(gebiet, linie);
	break;
      }
      n_header_items++;
    }
  }
  cout << "Briefmarken Ver.: " << version << " Sammelgebiet: " << gebiet << "\n";

  /*  M A I N L O O P  */
  while (!indat.eof()) {
    indat.getline(linie,1000);
    if ((linie[0]!='%') && (linie[0]!='\0')) {
      n_tok=0; is_quote=0; tok_pos=0;
      for (l_pos=0; l_pos<=strlen(linie); l_pos++) {
	if(linie[l_pos]=='"') 
	  if (is_quote) is_quote=0;
	  else is_quote=1;
	if((linie[l_pos]==',') || (linie[l_pos]=='\0')) {
	  if(!is_quote) {
	    strncpy(tok,(linie+tok_pos),(l_pos-tok_pos));
	    tok[l_pos-tok_pos]='\0';
	    if(tok[0]=='"') {
	      strncpy(f[n_tok],tok+1,strlen(tok)-2);
	      f[n_tok][strlen(tok)-2]='\0';
	    }
	    else strcpy(f[n_tok],tok);
	    cout << f[n_tok] << "\t";
	    tok_pos=l_pos+1;
	    n_tok++;
	  }
	}
      }
      cout << "\n";
      outdat << f[0] << ",\"" << f[1] << "\",\""
	     << f[2] << "\"," << f[3] << ","
	     << f[4] << ",\"" << f[5] << "\",\""
	     << f[6] << "\",\"" << f[7] << "\",33,27.5\n";
    }
  } /* endwhile */

  delete[]linie;
  indat.close(); outdat.close();

 ende: 
  return(0);

} /* Ende von main */



