#include "clp.h"

using namespace CLP;

static const option_t*
findShortOption(const option_t* options, char shortOption)
{
    for ( ; options->key != 0; ++options) {
	if (options->short_option != 0
	    && options->short_option == shortOption) return options;
    }
    throw CLP::invalid_option_error(std::string(1, shortOption));
}

static const option_t*
findLongOption(const option_t* options, const std::string& longOption)
{
    for ( ; options->key != 0; ++options) {
	if (options->long_option != 0
	    && std::string(options->long_option) == longOption) return options;
    }
    throw CLP::invalid_option_error(longOption);
}

static void foundOption(option_map_t& optout, const option_t* desc,
			const std::string& value)
{
    switch (desc->action) {
    case ACTION_MAP:
	optout.insert(option_map_t::value_type(std::string(desc->key), value));
	break;

    case ACTION_CALLBACK:
	if (desc->callback)
	    desc->callback(std::string(desc->key), value, desc->data);
	break;
    }
}

void CLP::parse(int argc, char ** argv, const option_t* options,
		option_map_t& optout, args_t& args)
{
    int i;

    for (i = 0; i < argc; ++i) {
	// Extract the current argument into a string object.
	std::string arg(argv[i]);

	// All interesting stuff starts with the option character.
	if (arg[0] == '-') {
	    if (arg.length() > 1 && arg[1] == '-') {
		if (arg.length() == 2) {
		    // The option terminator ("--") stops all processing.
		    ++i;
		    break;
		} else {
		    // First, search for an equals sign which
		    // seperates the long option from its value.
		    
		    std::string opt;
		    std::string::size_type equals_pos = arg.find("=", 2);
		    if (equals_pos != std::string::npos)
			opt = arg.substr(2, equals_pos - 2);
		    else
			opt = arg.substr(2);
		    
		    const option_t * desc = findLongOption(options, opt);
		    switch (desc->arg_type) {
		    case CLP::ARGUMENT_STRING:
			if (equals_pos != std::string::npos) {
			    foundOption(optout, desc,
					arg.substr(equals_pos + 1));
			} else {
			    if (i + 1 < argc) {
				foundOption(optout, desc, argv[i + 1]);
				++i;
			    } else {
				throw CLP::missing_value_error(opt);
			    }
			}
			break;

		    case CLP::ARGUMENT_NONE:
			if (equals_pos == std::string::npos)
			    foundOption(optout, desc, "");
			else
			    throw CLP::value_present_error(opt);
			break;
		    }
		}
	    } else {
		// Handle all short options present in the argument.
		
		for (std::string::size_type j = 1; j < arg.length(); ++j) {
		    char c = arg[j];
		    
		    const option_t * desc = findShortOption(options, c);
		    switch (desc->arg_type) {
		    case CLP::ARGUMENT_STRING:
			if (j + 1 < arg.length()) {
			    foundOption(optout, desc, arg.substr(j + 1));
			    goto break_for_loop; // C has no double break :(
			} else {
			    if (i + 1 < argc) {
				foundOption(optout, desc, argv[i + 1]);
				++i;
			    } else {
				throw CLP::missing_value_error(std::string(1, c));
			    }
			}
			break;

		    case CLP::ARGUMENT_NONE:
			// This option does not take a value.
			foundOption(optout, desc, "");
			break;
		    }
		}
	    break_for_loop:
		;
	    }
	} else {
	    // We found a normal parameter. Bail out of the loop.
	    break;
	}
    }
    
    // Place the remaining normal arguments into the "args" parameter.
    while (i < argc) {
	args.insert(args.end(), argv[i]);
	++i;
    }
}
