/*
 * Sample program which just displays a few simple items from a PDB or
 * PRC file.
 */

#include <iostream>
#include <string>

#include "File.h"

using namespace std;
using namespace PalmLib;

static string id2str(pi_int32_t v)
{
    string r;

    r += static_cast<char> ((v >> 24) & 0xFF);
    r += static_cast<char> ((v >> 16) & 0xFF);
    r += static_cast<char> ((v >> 8) & 0xFF);
    r += static_cast<char> (v & 0xFF);

    return r;
}

int main(int argc, char *argv[])
{
    if (argc != 2) {
	cerr << "usage: " << argv[0] << " PDB_FILE\n";
	return 1;
    }

    PalmLib::File pdb;

    try {
      pdb.load(argv[1]);
    } catch (PalmLib::error e) {
	cerr << argv[0] << ": " << argv[1] << ": " << e.what() << endl;
	return 1;
    }
  
    cout << "Name: '" << pdb.name() << "'" << endl;
    cout << "Creator: " << id2str(pdb.creator()) << endl;
    cout << "Type: " << id2str(pdb.type()) << endl;

    return 0;
}
