/*
 * palm-db-tools: Field definitions for flat-file database objects.
 * Copyright (C) 2000 by Tom Dyas (tdyas@users.sourceforge.net)
 */

#ifndef __PALMLIB_FLATFILE_FIELD_H__
#define __PALMLIB_FLATFILE_FIELD_H__

#include <string>

#include "libpalm/palmtypes.h"

namespace PalmLib {
    namespace FlatFile {

	class Field {
	public:
	    Field() : no_value(false), type(STRING), v_boolean(false),
		v_integer(0), v_float(0) { }
	    ~Field() { }

	    // True if this field has no value. (NULL in SQL terms)
	    bool no_value;

	    enum FieldType {
		STRING,
		BOOLEAN,
		INTEGER,
		FLOAT,
		DATE,
		TIME,
		DATETIME
	    };

	    enum FieldType type;

	    std::string v_string;
	    bool v_boolean;
	    PalmLib::pi_int32_t v_integer;
	    long double v_float;
	    struct {
		int month;
		int day;
		int year;
	    } v_date;          // valid for DATE and DATETIME
	    struct {
		int hour;
		int minute;
	    } v_time;          // valid for TIME and DATETIME
	};

    }
}

#endif
