#ifndef __PALMLIB_FLATFILE_FACTORY_H__
#define __PALMLIB_FLATFILE_FACTORY_H__

#include <string>

#include "libpalm/Database.h"
#include "Database.h"

namespace PalmLib {
    namespace FlatFile {

	class Factory {
	public:
	    /**
	     * Given a PalmOS database, allocate and fill a subclass
	     * of PalmLib::FlatFile::Database from the PalmOS
	     * database. The caller owns the returned object. NULL is
	     * returned if a suitable subclass could not be found.
	     *
	     * @param pdb The PalmOS database to interpret.
	     */
	    Database* makeDatabase(PalmLib::Database& pdb);

	    /**
	     * Given the user-visible name of a subclass of
	     * PalmLib::FlatFile::Database, find the correct subclass
	     * and instantiate it.
	     *
	     * @param name The name of the subclass to instantiate.
	     */
	    Database* newDatabase(const std::string& name);
	};

    }
}
#endif


