#include "Factory.h"
#include "DB.h"
#include "OldDB.h"
#include "MobileDB.h"
#include "ListDB.h"
#include "JFile3.h"

PalmLib::FlatFile::Database*
PalmLib::FlatFile::Factory::makeDatabase(PalmLib::Database& pdb)
{
    if (PalmLib::FlatFile::DB::classify(pdb))
	return new PalmLib::FlatFile::DB(pdb);
    if (PalmLib::FlatFile::OldDB::classify(pdb))
        return new PalmLib::FlatFile::OldDB(pdb);
    else if (PalmLib::FlatFile::MobileDB::classify(pdb))
	return new PalmLib::FlatFile::MobileDB(pdb);
    else if (PalmLib::FlatFile::ListDB::classify(pdb))
	return new PalmLib::FlatFile::ListDB(pdb);
    else if (PalmLib::FlatFile::JFile3::classify(pdb))
	return new PalmLib::FlatFile::JFile3(pdb);
    else
	return 0;
}

PalmLib::FlatFile::Database*
PalmLib::FlatFile::Factory::newDatabase(const std::string& name)
{
    if (PalmLib::FlatFile::DB::match_name(name))
	return new PalmLib::FlatFile::DB();
    if (PalmLib::FlatFile::OldDB::match_name(name))
        return new PalmLib::FlatFile::OldDB();
    else if (PalmLib::FlatFile::MobileDB::match_name(name))
        return new PalmLib::FlatFile::MobileDB();
    else if (PalmLib::FlatFile::ListDB::match_name(name))
	return new PalmLib::FlatFile::ListDB();
    else if (PalmLib::FlatFile::JFile3::match_name(name))
	return new PalmLib::FlatFile::JFile3();
    else
	return 0;
}
