#ifndef _UTIL_H
#define _UTIL_H

#include <string>
#include <vector>
#include <stdexcept>

class csv_parse_error : public std::runtime_error {
 public:
    csv_parse_error(const std::string & what_arg) :
	std::runtime_error(what_arg) { }
};

// Strip trailing characters.
std::string strip_back(const std::string & str, const std::string & what);

// Strip leading characters.
std::string strip_front(const std::string & str, const std::string & what);

// Parse a line from a standard CSV file and return it in a vector.
std::vector<std::string> csv_to_array(const std::string & str);

// Parse a line from an extended CSV file and return it in a vector.
std::vector<std::string> str_to_array(const std::string & str,
				      const std::string & delim,
				      bool multiple_delim);

#endif
