#include <iostream>
#include <string>

using namespace std;

#include "SimpleCmdlineParser.h"

class MyParser : public SimpleCmdlineParser
{
public:
  virtual const SimpleCmdlineParser::OptionMapping * getOptionMapping();

  virtual void foundOption(const CmdlineParser::OptionDescription * descr,
			   const string & opt,
			   const string & value);

  virtual void normalArguments(const vector<string> & args);
};

const SimpleCmdlineParser::OptionMapping * MyParser::getOptionMapping()
{
  static const SimpleCmdlineParser::OptionMapping mappings[] = {
    { 'f', "foo", { 'f', true } },
    { 'z', "bar", { 'z', false } },
    { '\0', "yoyo", { 'a', false } },
    { '\0', "", { '\0', false } }
  };

  return &mappings[0];
}

void MyParser::foundOption(const CmdlineParser::OptionDescription * descr,
			   const string & opt, const string & value)
{
  cout << "option: " << opt << endl;
  cout << "value: " << value << endl;
}

void MyParser::normalArguments(const vector<string> & args)
{
  int j = 0;
  for (vector<string>::const_iterator i = args.begin(); i != args.end(); ++i) {
    cout << "args[" << j << "]: " << *i << endl;
    ++j;
  }
}

int main(int argc, char *argv[])
{
  MyParser parser;

  parser.program = argv[0];

  if (! parser.parse(argc - 1, argv + 1))
    cout << "error detected" << endl;

  return 0;
}
