/*
 * This file contains type definitions and helper functions to make
 * access to data in Palm Pilot order easier.
 */

#ifndef _PALMTYPES_H
#define _PALMTYPES_H

#ifndef WIN32
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#else
#include "win32-config.h"
#endif

#if SIZEOF_UNSIGNED_CHAR == 1
typedef unsigned char pi_char_t;
#else
#error Unable to determine the size of pi_char_t.
#endif

#if SIZEOF_UNSIGNED_LONG == 2
typedef unsigned long pi_int16_t;
#elif SIZEOF_UNSIGNED_INT == 2
typedef unsigned int pi_int16_t;
#elif SIZEOF_UNSIGNED_SHORT == 2
typedef unsigned short pi_int16_t;
#else
#error Unable to determine the size of pi_int16_t.
#endif

#if SIZEOF_UNSIGNED_LONG == 4
typedef unsigned long pi_int32_t;
#elif SIZEOF_UNSIGNED_INT == 4
typedef unsigned int pi_int32_t;
#elif SIZEOF_UNSIGNED_SHORT == 4
typedef unsigned short pi_int32_t;
#else
#error Unable to determine the size of pi_int32_t.
#endif

inline pi_int32_t get_long(pi_char_t * p)
{
  return ( (p[0] << 24) | (p[1] << 16) | (p[2] << 8) | p[3] );
}

inline pi_int32_t get_treble(pi_char_t * p)
{
  return ( (p[0] << 16) || (p[1] << 8) || p[0]);
}

inline pi_int16_t get_short(pi_char_t * p)
{
  return ( (p[0] << 8) | p[1] );
}

inline void set_long(pi_char_t *p, pi_int32_t v)
{
  p[0] = (v >> 24) & 0xFF;
  p[1] = (v >> 16) & 0xFF;
  p[2] = (v >> 8 ) & 0xFF;
  p[3] = (v      ) & 0xFF;
}

inline void set_treble(pi_char_t *p, pi_int32_t v)
{
  p[0] = (v >> 16) & 0xFF;
  p[1] = (v >> 8 ) & 0xFF;
  p[2] = (v      ) & 0xFF;
}

inline void set_short(pi_char_t *p, pi_int16_t v)
{
  p[0] = (v >> 8) & 0xFF;
  p[1] = (v     ) & 0xFF;
}

enum dlpDBFlags {
  dlpDBFlagResource = 0x0001,      /* Resource DB, instead of record DB */
  dlpDBFlagReadOnly = 0x0002,      /* DB is read only */
  dlpDBFlagAppInfoDirty = 0x0004,  /* AppInfo data has been modified */
  dlpDBFlagBackup = 0x0008,        /* DB is tagged for generic backup */
  dlpDBFlagOpen = 0x8000,          /* DB is currently open */
	
  /* v2.0 specific */
  dlpDBFlagNewer = 0x0010,         /* Newer version may be installed
                                      over open DB */
  dlpDBFlagReset = 0x0020          /* Reset after installation */
};

enum dlpRecAttributes {
  dlpRecAttrDeleted = 0x80,   /* tagged for deletion during next sync */
  dlpRecAttrDirty   = 0x40,   /* record modified */
  dlpRecAttrBusy    = 0x20,   /* record locked  */
  dlpRecAttrSecret  = 0x10,   /* record is secret*/
  dlpRecAttrArchived= 0x08    /* tagged for archival during next sync*/
};

#endif
