/*
 * Sample program which just displays a few simple items from a PDB or
 * PRC file.
 */

#include <iostream>
#include <string>

#include "PalmDatabase.h"

using namespace std;

static string id2str(pi_int32_t v)
{
    string r;

    r += static_cast<char> ((v >> 24) & 0xFF);
    r += static_cast<char> ((v >> 16) & 0xFF);
    r += static_cast<char> ((v >> 8) & 0xFF);
    r += static_cast<char> (v & 0xFF);

    return r;
}

int main(int argc, char *argv[])
{
    if (argc != 2) {
	cerr << "usage: " << argv[0] << " PDB_FILE\n";
	return 1;
    }

    PalmDatabase db;

    try {
	db.load(argv[1]);
    } catch (PalmDatabase::error e) {
	cerr << argv[0] << ": " << argv[1] << ": " << e.what() << endl;
	return 1;
    }
  
    cout << "Name: '" << db.getName() << "'" << endl;
    cout << "Creator: " << id2str(db.getCreator()) << endl;
    cout << "Type: " << id2str(db.getType()) << endl;

    return 0;
}
