/*
 * SimpleCmdlineParser provides users with a simple mapping to make
 * CmdlineParser easier to use.
 */

#ifndef _SIMPLECMDLINEPARSER_H
#define _SIMPLECMDLINEPARSER_H

#include <string>

#include "CmdlineParser.h"

class SimpleCmdlineParser : public CmdlineParser
{
 public:
  struct OptionMapping {
    char short_name;
    char * long_name;
    CmdlineParser::OptionDescription descr;
  };

  std::string program;

  // Returns true if 'c' is a valid short option.
  virtual const CmdlineParser::OptionDescription * getShortOption(const char c);

  // Returns true if 'opt' is a valid long option.
  virtual const CmdlineParser::OptionDescription * getLongOption(const std::string & opt);

  // Called when an invalid option is found.
  virtual void unknownOption(const std::string & opt);

  // Called when an arugment needing a value is found but no value is present.
  virtual void missingValue(const std::string & opt);

  // Return the mapping of options to OptionDescription structures.
  virtual const OptionMapping * getOptionMapping() = 0;
};

#endif

