#include <iostream>
using namespace std;

#include "SimpleCmdlineParser.h"

const CmdlineParser::OptionDescription *
SimpleCmdlineParser::getShortOption(const char c)
{
  const OptionMapping * mapping = getOptionMapping();

  for (; mapping->short_name != '\0' || mapping->long_name[0]; ++mapping) {
    if (c == mapping->short_name) return &mapping->descr;
  }

  return 0;
}

const CmdlineParser::OptionDescription *
SimpleCmdlineParser::getLongOption(const string & opt)
{
  const OptionMapping * mapping = getOptionMapping();

  for (; mapping->short_name != '\0' || mapping->long_name[0]; ++mapping) {
    if (opt == mapping->long_name) return &mapping->descr;
  }

  return 0;
}

void SimpleCmdlineParser::unknownOption(const string & opt)
{
  cerr << program << ": unrecognized option `" << opt << "'" << endl;
}

void SimpleCmdlineParser::missingValue(const string & opt)
{
  cerr << program << ": option `" << opt << "' requires an argument" << endl;
}
