#ifndef _PALMRECORD_H
#define _PALMRECORD_H

#include "palmtypes.h"

class PalmRecord
{
 public:
  /* record header */
  pi_int32_t type;
  pi_int16_t id;
  pi_int32_t offset;
  pi_char_t attrs;
  pi_int32_t uid;

  /* record data */
  pi_char_t * data;
  int data_size;

  PalmRecord() : type(0), id(0), offset(0), attrs(0), uid(0), data(0),
    data_size(0) { }

  virtual ~PalmRecord() { if (data) delete [] data; }

  void setData(pi_char_t *d, int s) {
      if (data) {
	  delete [] data;
	  data = 0;
	  data_size = 0;
      }
      if (d) {
	  data = d;
	  data_size = s;
      }
  }

  pi_char_t category() const { return attrs & 0x0F; }
  void category(pi_char_t cat) { attrs &= ~0x0F; attrs |= (cat & 0x0F); }
};

#endif
