/*
 * This class provides access to MobileDB databases via the
 * DatabaseInterface methods. 
 */

#ifndef _MOBILEDB_H
#define _MOBILEDB_H

#include <vector>

#include "DatabaseInterface.h"

class MobileDB : public DatabaseInterface
{
 public:
    MobileDB();

    virtual void load(const char *);
    virtual void save(const char *);

    // Accessors to retrieve field information.
    virtual int getNumFields() const;
    virtual const FieldInfo & getField(int i) const;

    // Add a field to the schema.
    virtual void addField(const FieldInfo & info);

    // Returns true if this database supports a specific field type.
    virtual bool supportsFieldType(const FieldType & type);

    // Accessors to retrieve records.
    virtual int getNumRecords() const;
    virtual std::vector<FieldData> getRecord(int recNum) const;

    // Add a record to the database.
    virtual void addRecord(std::vector<FieldData> recData);

    // Return the global find enabled status.
    virtual bool getFindDisabledFlag() const;

    // Set the global find enabled status.
    virtual void setFindDisabledFlag(bool state);

    static const int mdbMaxFields;

    static const pi_char_t mdbCategoryFieldLabels;
    static const pi_char_t mdbCategoryDataRecords;
    static const pi_char_t mdbCategoryDataRecordsFout;
    static const pi_char_t mdbCategoryPreferences;
    static const pi_char_t mdbCategoryDataType;
    static const pi_char_t mdbCategoryFieldLengths;

 private:
    typedef struct  {
	pi_int16_t renamedCategories;
	char categoryLabels[16][16];
	pi_char_t categoryUniqIDs[16];
	pi_char_t lastUniqID;

	pi_char_t reserved1;
	pi_int16_t reserved2;
    } MobileAppInfoType;

    int find_metadata_by_category(pi_char_t theCategory);
    void parse_record(PalmRecord * record, std::vector<pi_char_t *> & array,
		      std::vector<int> & sizes) const;
    void make_record(PalmRecord &, const std::vector<std::string> &);
    void make_appinfo(const MobileAppInfoType &);

    std::vector<FieldInfo> fields;
};

#endif
