/*
 * This class provides access to some JFile 3 databases via the
 * DatabaseInterface methods.
 */

#ifndef _JFILE3DATABASE_H
#define _JFILE3DATABASE_H

#include "DatabaseInterface.h"

class JFile3 : public DatabaseInterface
{
 public:
    JFile3();

    virtual void load(const char *);

    // Accessors to retrieve field information.
    virtual int getNumFields() const;
    virtual const FieldInfo & getField(int i) const;

    // Add a field to the schema.
    virtual void addField(const FieldInfo & info);

    // Returns true if this database supports a specific field type.
    virtual bool supportsFieldType(const FieldType & type);

    // Accessors to retrieve records.
    virtual int getNumRecords() const;
    virtual std::vector<FieldData> getRecord(int recNum) const;

    // Add a record to the database.
    virtual void addRecord(std::vector<FieldData> recData);

    // Return the global find enabled status.
    virtual bool getFindDisabledFlag() const;

    virtual void setFindDisabledFlag(bool state);

 private:
    static const int JF3_CURRENT_VERSION;
    static const int JF3_MAX_FIND_STRING;
    static const int JF3_MAX_PASSWORD_LENGTH;
    static const int JF3_MAX_FIELDS;
    static const int JF3_MAX_FIELD_NAME_LENGTH;
    static const int JF3_MAX_DATA_LENGTH;
    static const int JF3_MAX_TOTAL_POPUP_LENGTH;
    static const int JF3_MAX_RECORDS;
    static const int JF3_MAX_RECORD_LENGTH;

    static const int JF3_FLDTYPE_STRING;
    static const int JF3_FLDTYPE_BOOLEAN;
    static const int JF3_FLDTYPE_DATE;
    static const int JF3_FLDTYPE_INT;
    static const int JF3_FLDTYPE_FLOAT;
    static const int JF3_FLDTYPE_TIME;
    static const int JF3_FLDTYPE_LIST;

    typedef struct {
	char fieldNames[20][20+1];
	int  fieldTypes[20];
	int  numFields;
	int  version;
	int  showDBColumnWidths[20];
	int  showDataWidth;
	int  sort1Field;
	int  sort2Field;
	int  sort3Field;
	int  findField;
	int  filterField;
	char findString[16];
	char filterString[16];
	int  lockPWOnExit;
	int  firstColumnToShow;
	struct {
	    int numStrings;
	    char ** strings;
	} popup_lists[20];
    } JFileAppInfoType, *JFileAppInfoPtr;

    void unpack_JFileAppInfoType(pi_char_t *p, JFileAppInfoPtr data);

    JFileAppInfoType header;
    std::vector<FieldInfo> fields;
};

#endif
