/*
 * The following base class defines an interface to flat file
 * databases on the Palm Pilot.
 */

#ifndef _DATABASEINTERFACE_H
#define _DATABASEINTERFACE_H

#include <vector>
#include <string>

#include "PalmDatabase.h"

class DatabaseInterface : public PalmDatabase
{
 public:
    // Supported field types.
    enum FieldType {
	STRING,
	INTEGER,
	BOOLEAN,
	DATE,
	TIME,
	FLOAT
    };

    // Description of a single field.
    struct FieldInfo {
	std::string name;
	FieldType type;
	int width;
    };

    // Structure to store data for a particular field.
    struct FieldData {
	FieldType type;
	std::string s;
	int i;
	bool b;
    };

    // Default constuctor.
    DatabaseInterface() : PalmDatabase(false) { }

    // Accessors to retrieve field information.
    virtual int getNumFields() const = 0;
    virtual const FieldInfo & getField(int i) const = 0;

    // Add a field to the schema.
    virtual void addField(const FieldInfo & info) = 0;

    // Returns true if this database supports a specific field type.
    virtual bool supportsFieldType(const FieldType & type) = 0;

    // Accessors to retrieve records.
    virtual int getNumRecords() const = 0;
    virtual std::vector<FieldData> getRecord(int recNum) const = 0;

    // Add a record to the database.
    virtual void addRecord(std::vector<FieldData> recData) = 0;

    // Return the global find disabled status.
    virtual bool getFindDisabledFlag() const = 0;

    // Set the global find enabled status.
    virtual void setFindDisabledFlag(bool state) = 0;
};

#endif
