/*
 * This class provides access to DB-format databases.
 */

#ifndef _DBDATABASE_H
#define _DBDATABASE_H

#include <vector>
#include <string>

#include "DatabaseInterface.h"

class DBDatabase : public DatabaseInterface
{
 public:
  DBDatabase();

  virtual void load(const char *);
  virtual void save(const char *);

  virtual int getNumFields() const;
  virtual const FieldInfo & getField(int i) const;

  virtual void addField(const FieldInfo & info);

  virtual bool supportsFieldType(const FieldType & type);

  virtual int getNumRecords() const;
  virtual std::vector<FieldData> getRecord(int recNum) const;

  virtual void addRecord(std::vector<FieldData> recData);

  virtual bool getFindDisabledFlag() const;
  virtual void setFindDisabledFlag(bool state);

 private:
  pi_int16_t dbFlags;
  std::vector<FieldInfo> fields;
};

#endif
