/*
 * CmdlineParser is a abstract base class for useful
 * command-line option parsers. Users should subclass it to actually
 * parse a specific set of options.
 */

#ifndef _CMDLINEPARSER_H
#define _CMDLINEPARSER_H

#include <vector>
#include <string>

class CmdlineParser
{
 public:
  struct OptionDescription {
    int cookie;
    bool takesValue;
  };

  virtual ~CmdlineParser() { }

  // Parse a command-line for options.
  bool parse(int argc, char *argv[]);

  // Returns true if 'c' is a valid short option.
  virtual const OptionDescription * getShortOption(const char c) = 0;

  // Returns true if 'opt' is a valid long option.
  virtual const OptionDescription * getLongOption(const std::string & opt) = 0;

  // Called when any option is found.
  virtual void foundOption(const OptionDescription *, const std::string & opt,
			   const std::string & value) = 0;

  // Called when an invalid option is found.
  virtual void unknownOption(const std::string & opt) = 0;

  // Called when an arugment needing a value is found but no value is present.
  virtual void missingValue(const std::string & opt) = 0;

  // Called when normal arugments are found.
  virtual void normalArguments(const std::vector<std::string> & args) = 0;
};

#endif
