#include <iostream>

using namespace std;

#include "CmdlineParser.h"

// The following routine implements the actual command-line
// parser. Calls are made to virtual functions overridden in a
// subclass to actually define the options recognized.

bool CmdlineParser::parse(int argc, char *argv[])
{
  string arg;
  int i;

  for (i = 0; i < argc; ++i) {
    arg = argv[i];
    int len = arg.length();

    // All interesting stuff start with the option character.
    if (arg[0] == '-') {

      if (len > 1 && arg[1] == '-') {
	// Found either a long option or end-of-options marker.

	if (len == 2) {
	  // The -- sequence marks the end of all option processing.
	  ++i;
	  break;
	} else {
	  // First, search for an equals sign which seperates the long
	  // option from its value.

	  string opt;
	  int equals_pos = arg.find("=", 2);
	  if (equals_pos != string::npos)
	    opt = arg.substr(2, equals_pos - 2);
	  else
	    opt = arg.substr(2);

	  const OptionDescription * descr = getLongOption(opt);
	  if (descr != 0) {
	    if (descr->takesValue) {
	      if (equals_pos != string::npos) {
		foundOption(descr, opt, arg.substr(equals_pos + 1));
	      } else {
		if (i + 1 < argc) {
		  foundOption(descr, opt, argv[i + 1]);
		  ++i;
		} else {
		  missingValue(opt);
		  return false;
		}
	      }
	    } else {
	      foundOption(descr, opt, "");
	    }
	  } else {
	    unknownOption(opt);
	    return false;
	  }
	} /* long option */
      
      } else {
      
	// Short options. Loop for each one.
	for (int j = 1; j < len; ++j) {
	  char c = arg[j];

	  const OptionDescription * descr = getShortOption(c);
	  if (descr != 0) {
	    if (descr->takesValue) {
	      if (j + 1 < len) {
		// Remainder of the string is the argument.
		foundOption(descr, string(1, c), arg.substr(j + 1));
		break;
	      } else {
		// Next argument is the argument value.
		if (i + 1 < argc) {
		  // Pass the next argument to the processing routine.
		  foundOption(descr, string(1, c), string(argv[i + 1]));
		  ++i;
		} else {
		  // Not enough arguments and this option needs a value.
		  missingValue(string(1, c));
		  return false;
		}
	      }
	    } else {
	      // This option does not take a value.
	      foundOption(descr, string(1, c), "");
	    }
	  } else {
	    unknownOption(string(1, c));
	    return false;
	  }
	}

      }
    } else {
      // Found a normal argument. Bail out of the loop.
      break;
    }
  }

  // Place the remaining normal arguments into a vector and let it be
  // processed by the subclass.
  vector<string> args;
  while (i < argc) {
    args.insert(args.end(), argv[i]);
    ++i;
  }
  normalArguments(args);

  return true;
}
