#ifndef _DB_H
#define _DB_H

#include <PalmOS.h>

#include "datasource.h"
#include "config.h"

#define prefFlagEnableFind      0x0001
#define prefFlagUpArrowPage     0x0002
#define prefFlagDownArrowPage   0x0004
#define prefFlagPageUpPage      0x0008
#define prefFlagPageDownPage    0x0010

#define DBCreatorID 'DBOS'
#define DBTypeID 'DB99'

#define offsetof(s,m) ( ((ULong) (&(s).m)) - ((ULong)&(s)) )

#define chooserSortOrderAlphabetic 0
#define chooserSortOrderManual     1

typedef struct {
    /* Flags */
    UInt16 flags;

    /* Current chooser category. */
    UInt16 ChooserCurrentCategory;
    Boolean ChooserShowAllCategories;
    Boolean ChooserForceRescan;
    UInt8 ChooserSortOrder;
} DBPrefsType, *DBPrefsPtr;

extern DataSource * CurrentSource;
extern DataSourceSchema *DesignViewInitialSchema;
extern DataSourceDriver *DesignViewDriver;
extern char *DesignViewName;
extern UInt16 CurrentRecord;
extern Boolean DesignNewDB;
extern UInt16 TopVisibleRecord;
extern UInt16 CurrentCategory;
extern Boolean IsNewRecord;
extern DBPrefsType prefs;
extern privateRecordViewEnum PrivateRecordStatus;
extern DataSourceDriver * DriverList;
extern UInt16 ListViewEditor_ViewNum;

/* Macros to allow functions to be placed in other code sections. */
#ifdef __GNUC__
#define SECT_UI  __attribute__ ((__section__("ui1sect")))
#define SECT_UI2 __attribute__ ((__section__("ui2sect")))
#define EDITSECT __attribute__ ((__section__("ui2sect")))
#else
#define SECT_UI
#define SECT_UI2
#define EDITSECT
#endif

/* Keep track of what features this PalmOS version has. */
extern Boolean FeatureSet30, FeatureSet31, FeatureSet32, FeatureSet35;

extern Boolean ChooserHandleEvent(EventPtr) SECT_UI;
extern Boolean DesignViewHandleEvent(EventPtr) SECT_UI;
extern Boolean ListViewHandleEvent(EventPtr) SECT_UI;
extern Boolean FindDialogHandleEvent(EventPtr) SECT_UI;
extern Boolean EditViewHandleEvent(EventPtr) EDITSECT;
extern Boolean ListViewEditor_HandleEvent(EventPtr event) SECT_UI;
extern Boolean ChooserInfoDialogHandleEvent(EventPtr) SECT_UI;
extern Boolean DuplicateDlgHandleEvent(EventPtr event) SECT_UI;
extern Boolean CreateDlgHandleEvent(EventPtr event) SECT_UI;
extern Boolean RenameDlgHandleEvent(EventPtr event) SECT_UI;
extern Boolean SortEditor_HandleEvent(EventPtr event) SECT_UI;
extern Boolean NamesEditorHandleEvent(EventType* event) SECT_UI;
extern Boolean HandleCommonMenuEvent(UInt16 menuitemID) SECT_UI;

extern void PopupDBPrefs(void) EDITSECT;
extern void PopupAppPrefs(void) EDITSECT;

extern void GlobalSearch(FindParamsPtr params);

extern void    DbgPrintF(const Char * fmt, ...) SECT_UI2;
extern char*   GetStringResource(UInt16 stringID);
extern void    PutStringResource(const char * str);
extern char *  CopyStringResource(UInt16 stringID);
extern Boolean IsNumber(const char * s);
extern Int32   String2Long(const char * cp);
extern Boolean MatchString(const char *, const char *, Boolean, Boolean);

extern void Chooser_AddDatabase(const char *title, UInt16 sourceID,
				void * key_data, UInt16 key_size) SECT_UI;
extern void Chooser_RenameDatabase(UInt16 sourceID,
				   void * old_key_data, UInt16 old_key_size,
				   void * new_key_data, UInt16 new_key_size,
				   const char* new_title) SECT_UI;

extern void MyWinDrawTruncChars(const char * str, UInt16 length,
				Int16 x, Int16 y, Int16 maxWidth);
extern void * DrawWorkingIndicator(void) SECT_UI2;
extern void EraseWorkingIndicator(void *) SECT_UI2;

#endif
