/******************************************************************************

	simple.c

	Simple authorization.

******************************************************************************/
#include <stdio.h>
#include <string.h>

#define MAX_LINE 100

/*
 * Return 1 if authentication ok.
 */
int auth (int user, FILE *getclient, FILE *sendclient)
{
	extern char *user_pass, *sue_pass;
	char line [MAX_LINE];
	char *pass = (user) ? sue_pass : user_pass;

	if (!pass) return 1;

	fputs ("* 9 Authorization Expected\n", sendclient);

	if (!fgets (line, MAX_LINE, getclient))
		return 0;

	/* Avoid long lines */
	if (line [strlen (line) - 1] != '\n')
	{
		do fgets (line, MAX_LINE, getclient);
		while (strlen (line) > 0 && line [strlen (line) - 1] != '\n');
		return 0;
	}

	line [strlen (line) - 1] = 0;

	return strcmp (line, pass) == 0;
}
