#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"

extern int connectlnsh ();

#define BUF_LEN 100

int main (int argc, char **argv)
{
	char tmp [BUF_LEN];
	FILE *f;
	int HTML = 0, i = 0;

	if (argc == 1)
	{
		fputs ("No arguments!\n", stderr);
		return 1;
	} else if (argc >= 2 && !(HTML = (!strcmp (argv [1], "-h")))) {
		fputs ("More than one argument.\n"
		       "The usage is: lnshfind [-h] 'foo bar'\n", stderr);
		return 1;
	}

	if (argc == 2 && HTML)
	{
		puts ("Content-Type: text/html\r\n\r\n"
		      "<HTML><HEAD><ISINDEX><TITLE>\n"
		      "Case insensitive search</TITLE></HEAD>\n"
		      "<BODY> lnshfind wrapper </BODY></HTML>\n");
		return 0;
	}

	if (strlen (argv [HTML + 1]) == 0)
		return 1;

	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "find %s\n", argv [HTML + 1]);
	fflush (f);

	if (HTML)
		printf ("Content-Type: text/html\r\n\r\n"
			"<HTML><HEAD>"
		      	"<ISINDEX><TITLE> Search for `%s'"
			"</TITLE></HEAD><BODY>"
			"Search Results<H2><UL>\n", argv [2]);

	for (;;i = 1)
	{
		if (!fgets (tmp, BUF_LEN, f))
			perror ("lnshfind::fgets");
		switch (tmp [0]) {
		case '-':
			i = -1;
			goto bbreak;
		case '*':
			goto bbreak;
		default:
			i = atoi (tmp);
			printf ((HTML) ? "<LI> <A HREF=%u> %u </A>\n" :
				 "%u\n", i, i);
		}
	}

bbreak:
	if (HTML) if (i == 0 || i == -1)
		puts ((i == 0) ? "No matches" : "Error");

	if (HTML) puts ("</UL></BODDY></H2></HTML>");

	return i;
}
