#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"

extern int connectlnsh ();

#define BUF_LEN 100

int main (int argc, char **argv)
{
	char tmp [BUF_LEN];
	FILE *f;

	if (argc < 3 || argc > 4)
	{
		fprintf (stderr, "Usage: lnshlinks ID1 ID2 [link id]\n");
		return 1;
	}
	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "link %u %u %i\n",
		 atoi (argv [1]), atoi (argv [2]),
		 (argc == 3) ? 0 : atoi (argv [3]));
	fflush (f);
	fgets (tmp, BUF_LEN, f);
	if (tmp [0] == '-')
	{
		fprintf (stderr, "Failed: %s", tmp);
		return 1;
	}

	return 0;
}
