/******************************************************************************

	The project logging messages use a printf-like function.
	But the destination (stream, memory..) does not concern the
	rest of the project.

	Logprintf (char fmt*, ...)

	has no destination in the arguments. The destination for
	the produced string is by default stderr but Logprintf can be
	overriden by the project custom logging.

******************************************************************************/
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include "sysutil.h"

static int stderrprintf (char *fmt, ...)
{
	va_list args;

	va_start (args, fmt);
	vfprintf (stderr, fmt, args);
	va_end (args);

	return 0;
}

static int stderrputs (char *s)
{
	return fputs (s, stderr);
}

int (*Logprintf) (char*, ...) = stderrprintf;
int (*Logputs) (char*) = stderrputs;


// ******************** The best place for these *********************

char *StrDup (char *c)
{
	return strcpy (new char [strlen (c) + 1], c);
}

char *iStrDup (char *c)
{
	return (isdata (c)) ? c : StrDup (c);
}

void iStrDelete (char *c)
{
	if (candelete (c)) delete c;
}
