/***************************************************************************
mozilla_open.C

This is a library function open_mozilla () which can be used from
other applications to invoke a netscape window with an url on demand.
For example like when we click on an URL in 'About' Section of an
application to get us to the site/home page of the application.

The trick is not to just open a new netscape with system ().
There may be locks that prevent us from cache and history access.
So here if a netscape window is already open, use ICCM to send
an openURL command to the mozilla window.

Sample implementation has been Patrick Hill's <apathos@bham.net>
wmnetselect select utility which makes your WM url friendly!
Check out http://home.att.net/~apathos/code/ for it.
***************************************************************************/
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xmu/WinUtil.h>

static Window find_mozilla (Display *dpy)
{
	Window foo, *child;
	unsigned int nchild, i;
	Atom type;
	Atom XA_MOZILLA_VERSION;
	int bar;
	unsigned long l1, l2;
	unsigned char *version = NULL;
	Window w;

	if ((XA_MOZILLA_VERSION = XInternAtom (dpy, "_MOZILLA_VERSION", True))
		== None)
		return None;

	if (!(XQueryTree (dpy, XRootWindow (dpy, DefaultScreen (dpy)),
		    &foo, &foo, &child, &nchild)))
		return None;

	for (i = 0; i < nchild; i++)
	{
		w = XmuClientWindow (dpy, child [i]);
		if (XGetWindowProperty (dpy, w, XA_MOZILLA_VERSION,
				0, 100, False, XA_STRING, &type, &bar,
				&l1, &l2, &version) == Success)
			if (version)
			{
				XFree (version);
				return w;
			}
	}

	return None;
}

int open_mozilla (Display *dpy, char *url)
{
	Window moz;
	char *tmp;
	Atom XA_MOZILLA_COMMAND;

	if ((XA_MOZILLA_COMMAND = XInternAtom (dpy, "_MOZILLA_COMMAND", True))
		== None)
		return 0;

	if ((moz = find_mozilla (dpy)) == None)
		return 0;

	tmp = (char*) alloca (strlen (url) + 25);

	sprintf (tmp, "openURL(%s,newwindow)", url);
	XChangeProperty (dpy, moz, XA_MOZILLA_COMMAND, XA_STRING,
			 8, PropModeReplace, (unsigned char*) tmp, 
			 strlen (tmp));
	XFlush (dpy);

	return 1;
}
