/******************************************************************************

	Entry to priviledged code.
	Operator ':' temporary redefined to accept priv_ macros.

******************************************************************************/
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

#include "projectlog.h"

#include "iServ.h"
#include "lnshell.h"
#include "epil.h"
#include "sysutil.h"

static void coded_query_lset ();

bool ExitRequested = false;

static char epriv [] = "':' commands NOT ALLOWED :";

static void nopriv_except (char *c)
{
	throw epilException (epriv, c);
}

static void priv_null ()
{
	ep_boolean = false;
}

static void priv_exit ();
static void priv_paranoid ();
static void priv_segv ();
static void priv_del ();
static void priv_groupm ();
static void priv_chgrp ();
static void priv_lset ();
static void priv_link ();
static void priv_unlink ();
static void priv_newelement ();
static void priv_newffile ();
static void priv_help ();
static void priv_rexec ();
static void priv_savedb ();
static void priv_shutdown ();
static void priv_altelement ();
static void priv_altffile ();
static void priv_dumpm ();

struct {
	const char *Name;
	void (*f) (void);
} Privs [] = {
	{ "altelement",		priv_altelement },
	{ "altffile",		priv_altffile },
	{ "chgrp", 		priv_chgrp },
	{ "del",		priv_del },
	{ "dump_macros",	priv_dumpm },
	{ "exit",		priv_exit },
	{ "groupm",		priv_groupm },
	{ "help", 		priv_help },
	{ "link",		priv_link },
	{ "lset",		priv_lset },
	{ "newelement",		priv_newelement },
	{ "newffile",		priv_newffile },
	{ "paranoid",		priv_paranoid },
	{ "quit",		priv_exit },
	{ "rexec",		priv_rexec },
	{ "savedatabase",	priv_savedb },
	{ "segv_now",		priv_segv },
	{ "shutdowndatabase",	priv_shutdown },
	{ "sys_reload",		priv_null },
	{ "unlink",		priv_unlink }
};

#define NPRIV sizeof Privs / sizeof Privs [0]

static int binsearch (char *c)
{
	int cond, l, h, m;

	for (l = 0; c [l]; l++)
		if (isupper (c [l])) c [l] = tolower (c [l]);

	l = 0, h = NPRIV - 1;
	while (l <= h) {
		m = (l + h) / 2;
		if ((cond = strcmp (c, Privs [m].Name)) < 0)
			h = m - 1;
		else if (cond > 0)
			l = m + 1;
		else return m;
	}

	return -1;
}

static char noprivc [] = "Waaaaah? :";

static void priv_gate (char *c)
{
	int i = binsearch (c);

	if (i == -1) throw epilException (noprivc, c);

	Privs [i].f ();
}

S *Newbies;

void priv ()
{
	CODED(query_lset);
	ep_register_ctrl (':', priv_gate);
	Newbies = EmptyS (StrDup ("Newbies"));
}

static bool paranoid = true;

static void nopriv (char*)
{ }

static char rexecfail [] = "Exception while executing :rexec code";

static void priv_rexec ()
{
	int Success;
	char *c;
	TMP_POP_ALLOC(c)

	ep_register_ctrl (':', (paranoid) ? nopriv_except : nopriv);
	lock_epil = true;

	Success = Zexec_unit (c) == 0;

	lock_epil = false;
	ep_register_ctrl (':', priv_gate);

	if (!Success) throw epilException (rexecfail);
}

void priv_register_coded (char *n, void (*foo)())
{
	int i = binsearch (n);

	if (i == -1) {
		Logprintf ("No priv :%s to redefine !\n", n);
		return;
	}

	Privs [i].f = foo;
}

static void priv_help ()
{
	unsigned int i;
	for (i = 0; i < NPRIV; i++)
		Logprintf (":%s\n", Privs [i].Name);
}

//*****************************************************************
//	 * * * ************ various Privs ************* * * *
//*****************************************************************

static void priv_segv ()
{
	int *a = NULL;
	*a = 1;
}

static void priv_exit ()
{
	ExitRequested = true;
}

static void priv_paranoid ()
{
	char *c;
	TMP_POP_ALLOC(c)

	paranoid = *c != '0';
}

static char noce [] = "Current element is not set";

static void ce ()
{
	if (!CurrentElement) throw epilException (noce);
}

static void priv_del ()
{
	ce ();

	unsigned int ID = Idof (CurrentElement);
	Reply R;

	Ln_Del (ID);
	if (!R.Status ()) {
		Logprintf ((R.StatusCode == 2) ?
			   "Element %u does not exist in the database\n" :
			   "Element %u cannot be removed\n", ID);
		return;
	}

	VoidID (ID);
}

static void p_mkgrp (char *c)
{
	if (*c == 0) return;

	Reply R;
	Ln_Mkgrp (c);

	if (!R.Status ()) Logprintf ((R.StatusCode == 1) ?
			   "Parent group of `%s' does not exist\n" :
			   (R.StatusCode == 3) ?
			   "`%s' is not a valid group name\n" :
			   "%s already exists\n", c);
}

static void p_rmgrp (char *c)
{
	if (*c == 0) return;

	Reply R;
	Ln_Rmgrp (c);

	if (!R.Status ()) Logprintf ((R.StatusCode == 1) ?
			   "Group `%s' does not exist\n" :
			   (R.StatusCode == 5) ?
			   "Group `%s' is used\n" :
			   "%s has elements or subgroups\n", c);
}

static void p_rengrp (char *o, char *n)
{
	Reply R;
	Ln_Rengrp (o, n);

	if (!R.Status ()) Logputs ((R.StatusCode == 1) ?
			   "Old name or parent of new name does not exist" :
			   (R.StatusCode == 3) ?
			   "New name is not a valid group name\n" :
			   (R.StatusCode == 4) ?
			   "New name already exists\n" : "I refuse\n");
	else renGroupNotify (o, n);
}

static void priv_groupm ()
{
	char *c, *p;
	TMP_POP_ALLOC(c)

	for (p = c + 1; isspace (*p); p++);
	if (*p == 0) return;

	switch (c [0]) {
	case 'c':
		p_mkgrp (p);
		break;
	case 'd':
		p_rmgrp (p);
		break;
	case 'r':
		for (c = p; (*c) && !isspace (*c); c++);
		if (*c) {
			*c++ = 0;
			while (isspace (*c)) c++;
			if (*c) {
				p_rengrp (p, c);
				break;
			}
		}
	default:
		Logputs ("Group manager commands:\n"
			 "n <groupname>\nd <groupname>\n"
			 "r <oldname> <newname>\n");
	}
}

static void priv_chgrp ()
{
	char *c;
	TMP_POP_ALLOC(c)

	ce ();

	Reply R;

	Ln_Chgrp (Idof (CurrentElement), c);
	if (!R.Status ())
		if (R.StatusCode == 1)
			Logprintf ("No such group : %s\n", c);
		else Logputs ("Current element has been removed!\n");
	else chgrpNotify (CurrentElement);
}

#define NOID ~0U

static unsigned int lsetID = NOID;

static void priv_lset ()
{
	ce ();

	lsetID = Idof (CurrentElement);
}

static void coded_query_lset ()
{
	if (lsetID == NOID) Logputs ("lset: No element set\n");
	else Logprintf ("lset with element ID [%u] (%i bytes) of group `%s'\n",
			lsetID, DataSize (EForID (lsetID)),
			GroupOf (EForID (lsetID)));
	if (!CurrentElement) Logputs ("No current element\n");
	else Logprintf ("Current element ID [%u] (%i bytes) of group `%s'\n",
			Idof (CurrentElement), DataSize (CurrentElement),
			GroupOf (CurrentElement));
}

static char elset [] = "Link element not set. Use :lset";

static void priv_link ()
{
	char *c;
	TMP_POP_ALLOC(c)

	ce ();

	if (lsetID == NOID) throw epilException (elset);

	Reply R;

	Ln_Link (lsetID, Idof (CurrentElement), (*c) ? strtol (c, NULL, 10) :0);

	if (!R.Status ()) Logputs ((R.StatusCode == 2) ?
				"One of the IDs does not exist\n" :
				"Already linked\n");
	else Logprintf ("Linked %u %u\n", lsetID, Idof (CurrentElement));
}

static void priv_unlink ()
{
	ce ();

	if (lsetID == NOID) throw epilException (elset);

	Reply R;

	Ln_Unlink (lsetID, Idof (CurrentElement));

	if (!R.Status ()) Logputs ("One of the IDs had been removed\n");
	else Logprintf ("Unlinked %u %u\n", lsetID, Idof (CurrentElement));
}

static char eexists [] = "Lndbase Element exists";
static char nogroup [] = "No such Lndbase group";

static void cwgroup ()
{
	char *c;
	TMP_POP_ALLOC(c)

	Reply R;

	Ln_Cd (c);

	if (!R.Status ()) {
		Logprintf ("No such group %s\n", c);
		throw epilException (nogroup);
	}
}

static char nullel [] = "Element with no content not accepted";

static int nz (int i)
{
	if (i == 0) throw epilException (nullel);
	return i;
}

static void priv_newelement ()
{
	char *c;
	TMP_POP_ALLOC(c)

	cwgroup ();

	LineReply LR;

	Ln_Newcl (nz (strlen (c)), c);

	if (!LR.Status ()) {
		Logprintf ("Element with content \"%s\" "
			"already exists in the database with ID %lu\n",
			c, strtoul (LR.DataLine, NULL, 10));
		throw epilException (eexists);
	}

	Add (Newbies, CurrentElement = EForID (strtoul (LR.DataLine, NULL, 10)));

	Logputs ("New Element Created.\n");
}

static char nofile [] = "Error opening file";

static void priv_newffile ()
{
	char *f;
	TMP_POP_ALLOC(f)

	cwgroup ();

	char *b = NULL;
	int i = filesize (f);
	if (i == -1) goto Errr;

	b = (char*) alloca (i);

	if (readfile (f, b, i)) {
Errr:
		Logprintf ("Cannot open file %s: [%s]\n", f, strerror (errno));
		throw epilException (nofile);
	}

	LineReply LR;

	Ln_Newcl (nz (i), b);
	if (!LR.Status ()) {
		Logprintf ("Element with content supplied from file"
			" \"%s\" already exists in the database with ID %lu\n",
			f, strtoul (LR.DataLine, NULL, 10));
		throw epilException (eexists);
	}

	Logputs ("New Element Created.\n");
}

static void priv_savedb ()
{
	Reply R;

	Ln_Save ();

	Logputs (R.StatusLine);
	Logputs ("\n");
}

static void priv_shutdown ()
{
	Reply R;

	Ln_Shutdown ();

	if (R.Status ())
		Logputs ("*******Database has been Shutdown*******\n");

	Logprintf (R.StatusLine);
}

static void priv_altelement ()
{
	char *c;
	TMP_POP_ALLOC(c)

	ce ();

	LineReply LR;
	Ln_Altcl (Idof (CurrentElement), nz (strlen (c)), c);

	if (!LR.Status ())
		if (LR.StatusCode == 4) {
		Logprintf ("Element with content \"%s\" "
			"already exists in the database with ID %lu\n",
			c, strtoul (LR.DataLine, NULL, 10));
			throw epilException (eexists);
		} else Logprintf ("Current element has been deleted\n");
	else RemoveCache (CurrentElement);
}

static void priv_altffile ()
{
	char *f;
	TMP_POP_ALLOC(f)

	ce ();

	char *b = NULL;
	int i = filesize (f);
	if (i == -1) goto Err;

	b = (char*) alloca (i);

	if (readfile (f, b, i)) {
Err:
		Logprintf ("Cannot open file %s: [%s]\n", f, strerror (errno));
		throw epilException (nofile);
	}

	LineReply LR;
	Ln_Altcl (nz (i), b);

	if (!LR.Status ())
		if (LR.StatusCode == 4) {
		Logprintf ("Element with content supplied from file"
			" \"%s\" already exists in the database with ID %lu\n",
			f, strtoul (LR.DataLine, NULL, 10));
			throw epilException (eexists);
		} else Logprintf ("Current element has been deleted\n");
}

static FILE *epfopn_w ()
{
	char *c;
	TMP_POP_ALLOC(c)
	return fopen (c, "w");
}

static void priv_dumpm ()
{
	FILE *f = epfopn_w ();

	if (!f) {
		Logprintf ("Cannot open file to dump macros:%s\n",
			   strerror (errno));
		return;
	}

	ep_dump_macros (f);

	fclose (f);

	Logputs ("Macro definitions dumped to file\n");
}
