#ifndef ARRAY_INCLUDED
#define ARRAY_INCLUDED

#include "dLIST.h"
#include "dbstree.h"
#include "graphics.h"

class Array;

class rowarea : public drawable
{
friend	class dargument_stack;
#define	CINDX (VSCR.cY + iA)
	int font;
	void context_draw ();
   protected:
	int iA;
	Array *A;
virtual	void drawtxt (int, char*);
virtual	void rowselect ();
   public:
	vscreen VSCR;
	vscrollbar SCRL;
	rowarea (int, int, int, Array*);
	void draw ();
	void setXY (int, int);
	void gotoend ();
	bool onclick ();
	int selected;
};


class Array
{
   protected:
virtual	char *cindex (int) = 0;
   public:
	Array ();
	char *operator [] (int);
virtual	unsigned int total () = 0;
virtual	int hint ();
	bool modified;
};

class dlistArray : public Array
{
	int lst;
   protected:
	dlistNode *L;
	dlist *D;
	dlistNode *nth_node (int);
   public:
	dlistArray (dlist*);
	unsigned int total ();
	int hint ();
};

class dbsArray : public Array
{
	int lst;
	dbsTree *d;
	dbsNode *n;
	char *cindex (int);
   public:
	dbsArray (dbsTree*);
	unsigned int total ();
	int hint ();
};

#endif
