/******************************************************************************
	interface to Lndbase server.

	The server commands are global defined instances of iCommand.
******************************************************************************/

#define ISERV_INCLUDED

// **** Replys ****

class Reply
{
   protected:
	int CheckLine (char*);
	virtual void Get ();
   public:
	Reply ();
	Reply (Reply&);
	char *StatusLine;
	int StatusCode;
	bool ds;
	int CheckReplyStatus (char*);
	int Status ();
	virtual void Release ();
	virtual ~Reply ();
friend	class iCommand;
friend	class iCommandCL;
};

class LineReply : public Reply
{
	virtual void Get ();
   public:
	LineReply ();
	LineReply (LineReply&);
	char *DataLine;
	void Release ();
};

class MultiLineReply : public Reply
{
   public:
	virtual void Get ();
	MultiLineReply ();
	MultiLineReply (MultiLineReply&);
	char **DataLine;
	int Lines;
	void Release ();
};

class shReply : public Reply
{
	virtual void Get ();
   public:
	shReply ();
	shReply (shReply&);
	char *Data;
	unsigned int ContentLength;
	void Release ();
};

// **** iCommands ****

#define QUERYLEN 200

class iCommand
{
   protected:
static	char query [QUERYLEN];
	char *cmd_name;
	bool suecmd;
	int SendQuery ();
   public:
	iCommand (char*, bool = 0);
static	Reply *CurrentReply;
static	void setReply (Reply*);
	void operator () (void);
	void operator () (unsigned int);
	void operator () (char*);
	void operator () (unsigned int, char*);
	void operator () (unsigned int, unsigned int);
	void operator () (unsigned int, unsigned int, int);
	void operator () (char*, char*);
friend	class ServerError;
};

class iCommandCL : public iCommand
{
   protected:
	unsigned int cl;
	void SendContent (void*);
   public:
	iCommandCL (char *c, bool b = 0) : iCommand (c, b) {};
	void operator () (unsigned int, void*);
	void operator () (unsigned int, unsigned int, void*);
	void operator () (unsigned int, unsigned int, char*, char**, void*);
};

// **** Interface ****

extern iCommand		Ln_New, Ln_Alt, Ln_Quit, Ln_Chgrp, Ln_Del, Ln_Link;
extern iCommand		Ln_Mkgrp, Ln_Rengrp, Ln_Rmgrp, Ln_Unlink, Ln_Unset;
extern iCommand		Ln_Set, Ln_Cd, Ln_Sue, Ln_Save, Ln_Shutdown;
extern iCommand		Ln_Groupof, Ln_Idof, Ln_Lenof, Ln_Pwd, Ln_Nlinks;
extern iCommand		Ln_Dir, Ln_Find, Ln_Ls, Ln_Stats, Ln_Typesof, Ln_Links;
extern iCommand		Ln_Sh, Ln_Vlink, Ln_Glinks, Ln_Nls;
extern iCommandCL	Ln_Newcl, Ln_Altcl, Ln_Idofcl, Ln_Locate;

extern bool connected, issue;
