/******************************************************************************

	stdm

	Very standard macros on the epil-macro base instance.

******************************************************************************/
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include "projectlog.h"

#include "epil.h"
#include "dbstree.h"

static unsigned int epatoui ()
{
	char *n;
	TMP_POP_ALLOC(n)

	return strtoul (n, NULL, 10);
}

static void coded_argstack ()
{
	Logprintf ("%u", ep_argstack);
}

static void coded_etrace ()
{
	Logprintf ("Etrace is %i\n", etrace = !etrace);
}

static void coded_strace ()
{
	Logprintf ("Strace is %i\n", strace = !strace);
}

static void coded_gdb_breakpoint ()
{
	// This is used to stop our gdb - The GNU Debugger in here.
	// By simply setting a breakpoint at this macro entry
	// and placing a \gdb_breakpoint in our code.
}

static char abrt [] = "\\ABORT called";

static void coded_ABORT ()
{
	throw epilException (abrt);
}

static void coded_EXIT ()
{
	ep_setexits (1);
}

static void coded_EXITto ()
{
	char *c;
	DAT_POP_ALLOC(c);
	ep_setexits (c);
}

static void coded_SKIP ()
{
	ep_setskips (1);
}

static void coded_SKIPto ()
{
	char *c;
	DAT_POP_ALLOC(c);
	ep_setskips (c);
}

static void coded_SKIP2 ()
{
	ep_setskips (2);
}

static void coded_SKIPif ()
{
	if (ep_boolean)
		ep_setskips (1);
}

#define HEADS (rand() & 1)

#if 0
// UNUSED. User-def macros will distribute in the balanced coded macros.
/******************************************************************************

	The Random Tree

	The dbstree is great in all cases except when lots of elements
	are inserted sorted. For example 1000 sorted by maro name \def
	commands. Actually it will be instant but for 100000 it won't.
	The complexity is not good.

	For that we use \sdef which is a tree where the comparison is
	50% for each case (never equal).
	Placing nodes randomly to less or more at each node will never
	result in an unbalanced tree (or play lotto instead).
	Reading the tree "in order" will result in a terrible scramble of
	the elements. The bad case (sorted) will be fixed, while a bad case
	cannot ever ever be created.
	Moving to chaos has no return and its good for our dbstree.
	Afterall extreme order is what we want to avoid and it can't come
	out of the ``rtree chaos''

	So the usage is:
		{ HELLO ``HELLO'\ECHO } \sdef
		{ FOO BAR } \sdef
		\sdef_realize

******************************************************************************/


dbsTree RTree;

class rtree : dbsNode
{
	int compare (dbsNode*);
	char *Name, *Definition;
	int compare ();
   public:
	rtree (char*, char*);
	~rtree ();
};

static rtree *RtRoot;

int rtree::compare (dbsNode*)
{
	return HEADS : 1 ? -1;
}

int rtree::compare ()
{
	return HEADS : 1 ? -1;
}

rtree::rtree (char *a, char *b) : dbsNode (&RTree)
{
	Name = a, Definition = b;
}

rtree::~rtree ()
{
	extern void ep_def (char*, char*);
	ep_def (Name, Definition);
}

static void coded_sdef ()
{
	char *c1, *c2;

	DAT_POP_ALLOC(c1);
	DAT_POP_ALLOC(c2);

	new rtree (c1, c2);
}

static void insert_dbs (dbsNode *n)
{
	rtree *r = (rtree*) n;
	delete r;
}

static void coded_sdef_realize ()
{
	RTree.foreach (insert_dbs);
	RtRoot = NULL;
}
#endif

/*****************************************************************************/

static void coded_isempty ()
{
	ep_boolean = ep_isempty ();
}

static void coded_pop ()
{
	POP_OUT;
}

static void coded_push ()
{
	ep_repush ();
}

static void coded_EPsetbp ()
{
	ep_setSbp ();
}

static void coded_EPdelbp ()
{
	ep_delSbp ();
}

void coded_execarg ()
{
	char *c;
	TMP_POP_ALLOC(c)

	exec_unit (c);
}

static void coded_epquote ()
{
	char *c;
	TMP_POP_ALLOC(c)

	ep_push_quoted_arg(c);
}

bool ep_boolean;

static void coded_T ()
{
	ep_boolean = true;
}

static void coded_F ()
{
	ep_boolean = false;
}

static void coded_if ()
{
	if (ep_boolean) {
		char *c;
		TMP_POP_ALLOC(c)
		exec_unit (c);
	} else {
		POP_OUT;
	}
}

static void coded_ifnot ()
{
	if (!ep_boolean) {
		char *c;
		TMP_POP_ALLOC(c)
		exec_unit (c);
	} else {
		POP_OUT;
	}
}

static void coded_ifelse ()
{
	char *c;

	if (ep_boolean) {
		TMP_POP_ALLOC(c)
		POP_OUT;
		exec_unit (c);
	} else {
		POP_OUT;
		TMP_POP_ALLOC(c)
		exec_unit (c);
	}
}
static void coded_altcount ()
{
	char t [10];
	sprintf (t, "%u", ep_pargs);

	ep_push (t);
}

static void coded_forarg ()
{
	int n = ep_pargs, i;
	char *c;

	TMP_POP_ALLOC(c);

	for (i = 0; i < n; i++)
		exec_unit (c);
}

static char divz [] = "\\fornarg: n=0";
static char remains [] = "\\fornarg: Remaining elements";

static void coded_fornarg ()
{
	int n = ep_pargs, i = epatoui ();
	char *e;
	TMP_POP_ALLOC(e);

	if (i == 0)
		throw epilException (divz);

	if (n % i) throw epilException (remains);
	n /= i;

	for (i = 0; i < n; i++)
		exec_unit (e);
}

static void coded_loop ()
{
	int i, j = epatoui ();
	char *c;
	TMP_POP_ALLOC(c)

	for (i = 0; i < j; i++)
		exec_unit (c);
}

static void coded_le ()
{
	char *c1, *c2;

	TMP_POP_ALLOC(c1);
	TMP_POP_ALLOC(c2);

	ep_boolean = strtol (c1, NULL, 10) < strtol (c2, NULL, 10);
}

static void coded_strcat ()
{
	char *c1, *c2;
	int l1, l2;

	l1 = ep_poplen ();
	c1 = (char*) alloca (l1 + 1);
	ep_pop (c1);
	l2 = ep_poplen ();
	c2 = (char*) alloca (l2 + l1 + 1);
	strcpy (c2, c1);
	ep_pop (c2 + l1);

	ep_push (c2);
}

static void coded_strcmp ()
{
	char *c1, *c2;

	TMP_POP_ALLOC(c1);
	TMP_POP_ALLOC(c2);

	ep_boolean = strcmp (c1, c2) == 0;
}

static void coded_strncmp ()
{
	char *c1, *c2;
	int m1, m2;

	m1 = ep_poplen ();
	c1 = (char*) alloca (m1 + 1);
	ep_pop (c1);
	m2 = ep_poplen ();
	c2 = (char*) alloca (m2 + 1);
	ep_pop (c2);

	ep_boolean = strncmp (c1, c2, (m1 < m2) ? m1 : m2) == 0;
}

static void coded_strcasecmp ()
{
	char *c1, *c2;

	TMP_POP_ALLOC(c1);
	TMP_POP_ALLOC(c2);

	ep_boolean = strcasecmp (c1, c2) == 0;
}

static void coded_echo ()
{
	char nl [] = "\n";

	char *c;
	TMP_POP_ALLOC(c);

	Logputs (c);
	Logputs (nl);
}

static void coded_echon ()
{
	char *c;
	TMP_POP_ALLOC(c);

	Logputs (c);
}

static void coded_tr ()
{
	char *c, *a, *p;
	TMP_POP_ALLOC(c)
	TMP_POP_ALLOC(a)

	if (c [0] != 0)
		// strchr (ptr, 0) should return NULL or the end of string ?
		// it returns the end of string. And we don't want to
		// replace the null terminator with a character!
		for (p = a; ; p++) {
			p = strchr (p, c [0]);
			if (p) *p = c [1];
			else break;
		}

	ep_push (a);
}

static void coded_toupper ()
{
	char *c;
	TMP_POP_ALLOC(c)
	int i;

	for (i = 0; c [i]; i++)
		c [i] = toupper (c [i]);

	ep_push (c, i);
}

static char strproc [] = "\\strproc : not implemented";
// String processing.
// Bash parameter expansion (%% ##) seems like a complete
// set of string separating routines.
// No regular expressions & case sensitive.
// We want before or after the first or the last occurence
// of word in string. Word is not included because it is known
// and can be appended.
// The first character can set the command.
// 'A' after first, 'B' before first, 'a' after last, 'b' before last.
static char *strfind (char *haystack, char *needle)
{
	return (needle [1]) ?
		strstr (haystack, needle) : strchr (haystack, needle [0]);
}
static char *strrfind (char *haystack, char *needle)
{
	if (needle [1] == 0) return strrchr (haystack, needle [0]);

	char sv, *psv, *pst, *occ;
	int nl;

	occ = NULL;
	nl = strlen (needle);
	sv = 0;
	psv = haystack + strlen (haystack);

	do {
		pst = psv - 2 * nl;
		if (pst < haystack) pst = haystack;
		if ((occ = strstr (pst, needle))) break;
		*psv = sv;
		psv -= nl;
		sv = *psv;
		*psv = 0;
	} while (pst > haystack);

	*psv = sv;

	return occ;
}

static void coded_strproc ()
{
	char *c, *s, *r;
	TMP_POP_ALLOC(c)
	TMP_POP_ALLOC(s)

	if (c [0] == 0 || c [1] == 0) throw epilException (strproc);

	switch (c [0]) {
	case 'a':
	case 'b':
		r = strrfind (s, c + 1); break;
	case 'A':
	case 'B':
		r = strfind (s, c + 1); break;
	default:
		throw epilException (strproc);
	}

	if (!r) {
		ep_push (s);
		return;
	}

	switch (c [0]) {
	case 'a':
	case 'A':
		ep_push (r + strlen (c + 1)); break;
	case 'b':
	case 'B':
		*r = 0; ep_push (s); break;
	}
}

static void coded_n ()
{
	ep_push ("\n", 1);
}

// An ambiguous verifier

static void coded_whatever ()
{
	ep_boolean = HEADS;
}

void stdm ()
{
	ep_register_coded ("clearstack", ep_clearstack);

	CODED(argstack);
	CODED(etrace);
	CODED(strace);
	CODED(gdb_breakpoint);
	CODED(ABORT);
	CODED(EXIT);
	CODED(EXITto);
	CODED(SKIP);
	CODED(SKIPto);
	CODED(SKIP2);
	CODED(SKIPif);
	CODED(isempty);
	CODED(pop);
	CODED(push);
	CODED(EPsetbp);
	CODED(EPdelbp);
	CODED(execarg);
	CODED(epquote);
	CODED(T);
	CODED(F);
	CODED(if);
	CODED(ifnot);
	CODED(ifelse);
	CODED(altcount);
	CODED(forarg);
	CODED(fornarg);
	CODED(loop);
	CODED(le);
	CODED(strcat);
	CODED(strcmp);
	CODED(strncmp);
	CODED(strcasecmp);
	CODED(echo);
	CODED(echon);
	CODED(tr);
	CODED(toupper);
	CODED(strproc);
	CODED(n);
	CODED(whatever);
}
