//*************************************************************************
//*************************************************************************
// Custom display - back to XWin.C -- main
//*************************************************************************
//*************************************************************************
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <stdio.h>
#include <ctype.h>

#include "graphics.h"
#include "popups.h"
#include "rows.h"
#include "readline++.h"
#include "epil.h"
#include "egui.h"
#include "INIT.h"

#define VP virtual public

int c_scr_bg = COL_BLACK;
int c_scr_fg = COL_WHITE;
int c_scr_rv = COL_SANDYBROWN;

void uf ()
{
	c_scr_bg = COL_WHITE;
	c_scr_fg = COL_BLACK;
	c_scr_rv = COL_BLUE;
}

//*****************************************

class epil_readline : VP Xreadline, VP normtab, VP history
{
   public:
	epil_readline ();
	void do_enter ();
};

epil_readline::epil_readline () :
breadline (" [epil]: "), Xreadline (0, 75, 7, 0, c_scr_bg, c_scr_fg),
history (100)
{ }

void epil_readline::do_enter ()
{
	addl ();
	Zexec_unit (line.line);
	line.reset (NULL);
	getCursor ();
}

//*********************************************************************

static rowarea *LRA;

class main_drawable : public drawable
{
  public:
	drawable *EGUI;
	epil_readline ERL;
	main_drawable (bool);
	void draw ();
	bool onclick ();
	bool operator == (drawable*);
};

main_drawable::main_drawable (bool startlog)
{
	EGUI = egui (90, 28, &ERL);

	if (startlog) {
		LRA = new rowarea (4, 73, 11, ivlog (73, true));
		LRA->VSCR.fg = c_scr_rv;
	}

	ERL.setXY (drawable::Bthick + EGUI->W, EGUI->H + 3);

	ERL.getCursor ();

	if (LRA) LRA->setXY (drawable::Bthick + EGUI->W,
			     EGUI->H + ERL.H + 5);

	FillRect (0, 0, scrX, scrY, 0);
}

bool main_drawable::onclick ()		// The Rhetorical function
{
	if (ERL.onclick () || EGUI->onclick () || (LRA && LRA->onclick ()));
	else return false;

	if (drawable::switchLight ()) draw ();

	return true;
}

void main_drawable::draw ()
{
	FillRect (0, 0, scrX, scrY, 0);
	EGUI->draw ();
	ERL.draw ();
	if (LRA) LRA->draw ();
}

bool main_drawable::operator == (drawable *d)
{
	return (*EGUI) == d;
}

//*********************************************************************

static main_drawable *Main;

void visual_catchup ()
{
	if (LRA) LRA->gotoend ();
}

void coded_crap ();

drawable *InitEnv (bool startlog)
{
	gLevels::addlevel (Main = new main_drawable (startlog));

	JCursor::On = true;
	JCursor::Flashing = true;
	JCursor::font = 0;
	JCursor::fg = 1;
	JCursor::bg = 0;
	JCursor::Symbol [0] = ' ';
	JCursor::Symbol [1] = 0;

	visual_catchup ();

	CODED(crap);

	return Main;
}

void do_char (int c)
{
	if (JCursor::On == false)
		JCursor::On = true;

	if (!JCursor::Readline && gLevels::toplev () == Main)
		Main->ERL.getCursor ();

	JCursor::do_char (c);

	if (isalnum (c)) if (drawable::switchLight ())
		gLevels::drawall ();
}

//*********************************************************************
void coded_crap ()
{
#define BASE 1000
#define XTR(N) ((rX * N) / BASE)
#define YTR(N) ((rY * N) / BASE)
#define DRAWLINE(x, y, w, h, c) D.drawline(XTR(x), YTR(y), XTR(w), YTR(h), c)
#define DRAWRECT(x, y, w, h, c) D.drawrect(XTR(x), YTR(y), XTR(w), YTR(h), c)
#define DRAWSTRING(s, x, y) D.drawstring(s, XTR(x), YTR(y), 2, COL_WHITE)
	int rX = scrX - Main->EGUI->W - LRA->W - 2;
	int rY = scrY - Main->EGUI->H - Main->ERL.H - 2;
	drawable D (scrX - rX, scrY - rY, rX, rY);

	D.fill_block (COL_BLACK);

	DRAWSTRING("my name is znort", 110, 100);
	DRAWSTRING("can i help you ?", 110, 200);

	// Head
	DRAWRECT(300,400 ,400, 310 , COL_WHITE);

	// Left eye
	DRAWRECT(360,500, 100, 60, COL_WHITE);
	DRAWLINE(360, 510, 450, 510, COL_LIGHTGREY);
	DRAWLINE(360, 515, 450, 515, COL_LIGHTGREY);
	DRAWRECT(380, 540, 20, 10, COL_SANDYBROWN);

	// Right eye
	DRAWRECT(550, 500, 100, 60, COL_WHITE);
	DRAWLINE(550, 510, 640, 510, COL_LIGHTGREY);
	DRAWLINE(550, 515, 640, 515, COL_LIGHTGREY);
	DRAWRECT(600, 540, 20,  10, COL_SANDYBROWN);

	// Left ear
	DRAWRECT(260, 450,  40, 150, COL_WHITE);
	DRAWLINE(280, 450, 180, 390, COL_WHITE);

	// Right ear
	DRAWRECT(700, 450,  40, 150, COL_WHITE);
	DRAWLINE(720, 450, 830, 400, COL_WHITE);

	// Then the small fonts became larger and znort
	// was squeezed into the borders
}
