/*****************************************************************************
 *                      rencode.c - source of the encoding tool              *
 *                     -----------------------------------------             *
 *          begin:             Mon Jun 3  1:21:52 CEST 1999                  *
 *          copyright:         (C) 1999 by Rene van Bevern                   *
 *          eMail:             RvB@pro-linux.de                              *
 *          ICQ #:             42438601                                      *
 *****************************************************************************/

/*****************************************************************************
 * This program is free software; you can redistribute and/or modify it      *
 * under the terms of the GNU General Public Licence as published by the     *
 * Free Software Foudation (FSF); either version 2 of the License or (at     *
 * your opinion) any later version,                                          *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <main.h>
int main (int argc, char **argv)
{
  char tmpchar;
  int wordsum;
  int use_stdin=0;
  int use_stdout=0;
  FILE *inputstream;
  FILE *outputstream;
  GPL;
  WARRANTY;
  if (argc != 4)
    {
      printf ("Usage: %s <file_to_encode> <name_for_encoded_file> <password>\n\n", argv[0]);
      return (1);
    }

  if(!strcmp(argv[1],"-")) { inputstream=stdin; use_stdin=1; }
  if(!strcmp(argv[2],"-")) { outputstream=stdout; use_stdout=1; }
  if(use_stdin!=1)  inputstream = fopen (argv[1], "r");
  if (!inputstream)
  {
      fprintf (stderr, "Couldn't open %s for input!\n\n", argv[1]);
      return (1);
  }
  if (use_stdout!=1)  outputstream = fopen (argv[2], "w");
  if (!outputstream)
  {
      fprintf (stderr, "Couldn't open %s for output!\n\n", argv[2]);
      return (1);
  }
  wordsum = sumword (argv[3]);

  if (feof (inputstream))  return(0);
  while (!feof (inputstream))
  {
      tmpchar = encode (fgetc (inputstream), wordsum, strlen(argv[3]));
      if (feof (inputstream))
      {
          SUCCEED;
          return (0);
      }
      fputc (tmpchar, outputstream);
  }
  return( 0 );
}
