proc SeditExternalCmd { draft t cmd } {
    # Save message, process with external command, and reload
    # last argument to command will be draft file name.
    SeditSave $draft $t
    if [catch {eval exec $cmd $draft} err] {
	Exmh_Debug "$err while executing external command."
    } else {
	if [catch {open $draft r} in] {
	    SeditMsg $t "Cannot open $draft"
	} else {
	    $t delete 1.0 end
	    SeditMimeReset $t
	    $t insert 1.0 [read $in]
	    close $in
	    SeditPositionCursor $t
	    SeditMimeParse $t
	}
    }
}


proc Message_ExternalCmd { cmd {interactive 1} } {

    Exmh_Debug $cmd
    eval $cmd
    Msg_ShowCurrent
}
