;; Some emacs lisp code you may find useful.

(setq comint-password-prompt-regexp "\\(\\([Oo]ld \\|[Nn]ew \\|^\\)[Pp]assword\\|pass phrase\\|Passphrase\\):\\s *\\'")

(add-hook 'shell-mode-hook
	  (lambda () (local-set-key "\C-c\C-m" 'mapil-return)))

(defun mapil-encode ()
  "Process mail buffer with mapil, user I/O through buffer"
  (interactive)
  (save-buffer)
  (setq explicit-shell-file-name "mapil")
  (setq explicit-mapil-args (list "-C" buffer-file-name))
  (shell))

(defun mapil-return ()
  "Return to former buffer, kill mapil session and revert."
  (interactive)
  (kill-buffer (current-buffer))
  (revert-buffer t t)
  (setq explicit-shell-file-name nil))
