#!/usr/bin/env python

print """

Starting Mapil installation.  If there are any problems with this,
please mail me at bescoto@stanford.edu.

I encourange anyone who is interested in Mapil to join the mailing
list by sending a message to majordomo@lists.stanford.edu with
"subscribe mapil-list" on a blank line (omit the quotes).



If the below fails, you do not have a necessary module.  Usually this
is because python was installed incorrectly at your site.  However, if
you think that Mapil is requiring a module that many people don't
have, mail me and I may try to work around it.

Checking modules...
"""

import os, sys, string, getopt, rfc822, tempfile, regex, marshal, \
       rand, termios, TERMIOS, types, StringIO, base64, py_compile

print "All necessary modules found, Mapil should run."
sys.stdout.write('Press return to continue: ')
sys.stdin.readline()
print """
To save time loading, this script will byte compile the mapil.py file,
producing a mapil.pyc file.  A small bootstrap script called 'mapil'
will be created in this directory.  Then, whenever Mapil is run,
python will execute the byte code instead of the mapil.py source,
cutting loading time by about 75%.

Creating mapil.pyc..."""
py_compile.compile('mapil.py', 'mapil.pyc')
sys.stdout.write('Done, press return to continue: ')
sys.stdin.readline()
print """

In order to create the 'mapil' loader, this script needs to know where
you intend to put 'mapil.py' and 'mapil.pyc' if it is not in the
python module search path.  Here are the currently searched
directories:
"""

for directory in sys.path:
    print directory

print """

If you intend to place mapil in one of these directories, leave the
following prompt blank.  Otherwise, enter the directory where
'mapil.py' and 'mapil.pyc' will go."""

while 1:
    print
    sys.stdout.write("Directory: ")
    dir = string.strip(sys.stdin.readline())

    if not dir:
	print 'Assuming files will be found by normal module search.'
	break
    else:
	try: os.stat(dir)
	except:
	    print 'Error, directory not found'
	    continue

	print 'Directory ' + dir + ' found.'
	break

print
print "Creating 'mapil' loader..."
fpmapil = open('mapil', 'w')
fpmapil.write('#!/usr/bin/env python\n')
if dir:
    fpmapil.write('import sys\n')
    fpmapil.write("sys.path.append('" + dir + "')\n")
fpmapil.write('import mapil\n')
fpmapil.close()
os.chmod('mapil', 0755)

print """

That's it!  Now just copy 'mapil' to a convenient location (say,
/usr/local/bin) and copy 'mapil.py' and 'mapil.pyc' to the appropriate
directory you decided on above.

"""
