/*
 * pgpconfig.h
 *
 * Copyright (c) 1997 Christian Stueble stueble@ls6.cs.informatik.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __KPGPCONFIG_H__
#define __KPGPCONFIG_H__

#include <qframe.h>
#include <qmsgbox.h>
#include <qlabel.h>
#include <qbttngrp.h>
#include <qradiobt.h> 
#include <qpixmap.h>
#include <qgrpbox.h> 
#include <qpainter.h>
#include <qbttngrp.h>
#include <qlcdnum.h>

#include <qchkbox.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlayout.h>
#include <qdict.h>

#include <kcontrol.h>
#include <ksimpleconfig.h>

class KPGPConfig : public KConfigWidget
{
  Q_OBJECT;
  
public:
  
  KPGPConfig( QWidget *parent=0, const char* name=0 );
  ~KPGPConfig( );
  
  void  resizeEvent(QResizeEvent *e);
  
  void loadSettings();
  void applySettings();
  
private slots:
  
  void slotChoosePubring();
  void slotChooseSecring();
  void slotChooseSeedFile();
  
  void slotCertDepthChanged( const char * );
  void slotCompleteNeededChanged( const char * );
  void slotMarginalNeededChanged( const char * );
  
private:
  
  QWidget*      fileSettings(QPushButton* &btn, QString name, QLineEdit * &ledit);
  QWidget*      getCheckSettings();
  QWidget*      getNameSettings();
  QWidget*      getTrustSettings();
  QWidget*      getCommentSettings();
 
  bool          openConfig(QString name);
  
  bool          config_found;
  KSimpleConfig *config;
 
  QString       pgpPath;
  QString       config_file;
  
  int           COMPLETES_NEEDED;
  int           MARGINALS_NEEDED;
  int           CERT_DEPTH;
  int           VERBOSE;
  
  QString       PUBRING;
  QString       SECRING;
  QString       RANDSEED;
  
  QString       COMMENT;
  
  bool          INTERACTIVE;
  bool          COMPRESS;
  bool          KEEPBINARY;
  bool          ARMOR;
  bool          TEXTMODE;
  bool          SHOWPASS;
  bool          CLEARSIG;
  bool          ENCRYPTTOSELF;
  
  QLineEdit     *mynameEdit;
  QLineEdit     *commentEdit;
  
  QLineEdit     *pubringEdit;
  QPushButton   *pubringSelect;
  
  QLineEdit     *secringEdit;
  QPushButton   *secringSelect;
  
  QLineEdit     *seed_fileEdit;
  QPushButton   *seed_fileSelect;
  
  QCheckBox     *checkINTERACTIVE;
  QCheckBox     *checkCOMPRESS;
  QCheckBox     *checkKEEPBINARY;
  QCheckBox     *checkARMOR;
  QCheckBox     *checkTEXTMODE;
  QCheckBox     *checkSHOWPASS;
  QCheckBox     *checkCLEARSIG;
  QCheckBox     *checkENCRYPTTOSELF;
};

#endif