/*
 * pgpkey.cpp
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pgpkey.h"
#include "pgpuserid.h"


// ---------- static member ---------

PgpKey* PgpKey::defaultKey = 0;     // points to the default private key

PgpKey*  
PgpKey::getDefaultKey()
{
  return defaultKey;
};

// ----------------------------------

PgpKey::PgpKey(QDataStream &source, UINT8 ctb) :
  is_default(FALSE),
  is_revoked(FALSE),
  is_private(FALSE),
  userId_list(new QList<PgpUserId>), 
  revocation_list(new QList<PgpSignature>)
{};

PgpKey::~PgpKey()
{};

bool 
PgpKey::isDefault()
{
  return is_default;
};

bool 
PgpKey::isRevoked()
{
  return is_revoked;
};

bool 
PgpKey::isPrivate()
{
  return is_private;
};

bool        
PgpKey::isPaused()
{
  return is_paused;
};

void 
PgpKey::insertUserId(PgpUserId *userId, int pos)
{
  if ((pos != -1) && pos <= userId_list->count())
    userId_list->insert(pos, userId);
  else
    userId_list->append(userId);
};

bool
PgpKey::removeUserId(PgpUserId *userId)
{
  return userId_list->remove(userId);
};

/*
void    
PgpKey::addMySignature(PgpSignature *mysig)
{
  mySignature_list->append(mysig);
};
*/

void     
PgpKey::addRevocation(PgpSignature *sig)
{
  revocation_list->append(sig);
  
  if (sig->keyId() == keyId())
    is_revoked = TRUE;
  else
    is_revoked = FALSE;
};

PgpUserId*  
PgpKey::getUserId(int nr)
{
  return userId_list->at(nr);
};

int         
PgpKey::count()
{
  return userId_list->count();
};
