/*
 * pgpconfig.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PGPCONFIG_H
#define PGPCONFIG_H

#include "pgpkey.h"

#include <kconfig.h>
#include <qstring.h>

class PgpConfig
{
public:
  
  static PgpConfig* getPgpConfig();

public:

  enum Flag {
    Textmode,
    Armor,
    Keepbinary,
    Compress,
    Showpass,
    Clearsig,
    EncryptToSelf,
    Interactive
  };

  /// stores values
  virtual void    apply() = 0;

  /// restores dafault values
  virtual void    setDefault() = 0;

  /** return path to the pgp directory **/
  virtual QString pgpPath() const = 0;

  /** set pgp flags **/
  virtual void    setFlag(Flag flag, bool value) = 0;

  /** get pgp flags **/
  virtual bool    getFlag(Flag flag) const = 0;

  /** make key the default private key **/
  virtual void    setDefaultKey(QString myname) = 0;
  /** return the default key **/
  virtual QString getDefaultKey() const = 0;

  virtual void    setPubring(QString pubring) = 0;
  virtual QString getPubring() const = 0;

  virtual void    setSecring(QString secring) = 0;
  virtual QString getSecring() const = 0;

  virtual void    setRandseed(QString randseed) = 0;
  virtual QString getRandseed() const = 0;

  /** set default pgp comment **/
  virtual void    setComment(QString comment) = 0;
  /** get default pgp comment **/
  virtual QString getComment() const = 0;

  /** number of marginaly trusted introducers needed **/
  virtual void    setMarginalsNeeded(int marginals = 2) = 0;
  virtual int     getMarginalsNeeded() const = 0;

  /** number of completely trusted introducers needed **/
  virtual void    setCompletesNeeded(int completes = 1) = 0;
  virtual int     getCompletesNeeded() const = 0;

  /** select how deep introducers may be nested **/
  virtual void    setCertDepth(int depth = 4) = 0;
  virtual int     getCertDepth() const = 0;

  /** set verbose mode **/
  virtual void    setVerbose(int verbose) = 0;
  virtual int     getVerbose() const = 0;

protected:
  
  PgpConfig();
  virtual ~PgpConfig();

  KConfig *config;

protected:

  static PgpConfig* pgpconfig;
};

#endif
