/*
 * pgptreelist.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PGPTREELIST_H
#define PGPTREELIST_H

#include <qevent.h>

#include <ktreelist.h>
#include <kpopmenu.h>

#include "pgpkey.h"
#include "pgpuserid.h"
#include "pgpsignature.h"

class PgpUserIdItem;
class PgpSignatureItem;

class PgpKeyItem : public KTreeListItem
{
public:

  PgpKeyItem(PgpKey *key);
  ~PgpKeyItem();

  void  setRightMenu(KPopupMenu *menu);
  void  setLeftMenu(KPopupMenu *menu);

  PgpKey* getKey();

  void  update();
  void  setTrust(UINT8 trust);
  void  pauseKey();
  
  /// appends a new userID
  PgpUserIdItem*  newUserId(QString uid);

  /// @return a pointer to user ID no. nr
  PgpUserIdItem*  getUserId(int nr=0);

  /// removes userid uid
  void            removeUserId(PgpUserIdItem *uid);

  /// revokes key. NOT IMPLEMENTED
  void            revokeKey();

  /// makes key the default private key
  void            setDefault(bool value);

  /// appends new_sig to the default user-ID
  void            addSignature(PgpSignature *new_sig);

protected:

  /// updates pixmap
  void setPix();

protected:

  KPopupMenu     *myMenu;
  PgpKey         *myKey;
};

class PgpUserIdItem : public KTreeListItem
{
public:

  PgpUserIdItem(PgpUserId *uid);
  ~PgpUserIdItem();

  void  setRightMenu(KPopupMenu *menu);
  void  setLeftMenu(KPopupMenu *menu);
  void  addSignature(PgpSignature *new_sig);
  
  void  update();
  PgpUserId* getUserId();
  
protected:

  void setPix();

protected:

  PgpUserId         *myUserId;
};

class PgpSignatureItem : public KTreeListItem
{
public:

  PgpSignatureItem(PgpSignature *signature);
  ~PgpSignatureItem();

  void  setRightMenu(KPopupMenu *menu);
  void  setLeftMenu(KPopupMenu *menu);

  PgpSignature* getSignature();

protected:

  void setPix();

protected:

  PgpSignature         *mySignature;
};



class PgpTreeList : public KTreeList
{
  Q_OBJECT
public:
    
  PgpTreeList(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
  virtual ~PgpTreeList();
   
signals:

  void leftMenuSelected(QPoint, int);
  void rightMenuSelected(QPoint, int);

protected:
    
  virtual void mousePressEvent(QMouseEvent *e);
  virtual void mouseReleaseEvent(QMouseEvent *e);
};

#endif
