/* main.c - main source of fxor
   fxor - For XOR, is an encryption program written and copyrighted by Eli Gottlieb, 2004.
   This program is free software under the GNU General Public License version 2.  Or, at the users option, any further version 
   may be used.                                                                    */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include "config.h"

typedef struct TfxorOut
{
char* pcData;
unsigned int ulLength;
} fxorOut;
fxorOut fxor_encrypt(char* pcData,char* pcKey,unsigned int ulDataLength,unsigned int ulKeyLength)
{
fxorOut foOut;
foOut.pcData = malloc(ulDataLength);
 foOut.ulLength = ulDataLength;
int i=0,k=0;
for(int j=0;j<ulDataLength;j++)
 {
 foOut.pcData[j] = pcData[j] ^ pcKey[i];
 k++;
 if(k >= ulKeyLength)
  {
  k = 0;
  i++;
  if(i >= ulKeyLength)
   i = 0;
  };
 };
i = 0;
for(int j=0;j<ulDataLength;j++)
 {
 foOut.pcData[j] = foOut.pcData[j] ^ pcKey[i];
 i++;
 if(i >= ulKeyLength)
  i = 0;
 };
return foOut;
}

fxorOut fxor_decrypt(char* pcData,char* pcKey,unsigned int ulDataLength,unsigned int ulKeyLength)
{
fxorOut foOut;
foOut.pcData = malloc(ulDataLength);
 foOut.ulLength = ulDataLength;
int i = 0;
for(int j=0;j<ulDataLength;j++)
 {
 foOut.pcData[j] = pcData[j] ^ pcKey[i];
 i++;
 if(i >= ulKeyLength)
  i = 0;
 };
int k = 0;
i = 0;
for(int j=0;j<ulDataLength;j++)
 {
 foOut.pcData[j] = foOut.pcData[j] ^ pcKey[i];
 k++;
 if(k >= ulKeyLength)
  {
  k = 0;
  i++;
  if(i >= ulKeyLength)
   i = 0;
  };
 };
return foOut;
}

int main(int argc,char* argv[])
{
if(argc < 4)
 {
 printf("3 parameters are needed: a command (\"encrypt\" or \"decrypt\"), a file to operate on, and a key.\nThey are needed in that order.\n");
 exit(1);
 };
struct stat stFile;
if(stat(argv[2],&stFile) == -1)
 {
 fprintf(stderr,"Could not stat file %s.\n",argv[2]);
 exit(2);
 };
char* pcData = malloc(stFile.st_size);
int fdFile = open(argv[2],O_RDONLY);
int iReturn = read(fdFile,pcData,stFile.st_size);
close(fdFile);
if(iReturn == -1)
 {
 fprintf(stderr,"Couldn't read from file %s.\n",argv[2]);
 exit(3);
 };
fxorOut foData;
char* strNewFile;
if(strcmp(argv[1],"encrypt") == 0)
 {
 foData = fxor_encrypt(pcData,argv[3],stFile.st_size,strlen(argv[3]));
 strNewFile = malloc(strlen(argv[2])+1);
 strcpy(strNewFile,argv[2]);
 };
if(strcmp(argv[1],"decrypt") == 0)
 {
 foData = fxor_decrypt(pcData,argv[3],stFile.st_size,strlen(argv[3]));
 strNewFile = malloc(strlen(argv[2])+1);
 strcpy(strNewFile,argv[2]);
 };
fdFile = open(strNewFile,O_WRONLY | O_CREAT);
if(fdFile == -1)
 {
 fprintf(stderr,"Couldn't open output file %s.\n",strNewFile);
 free(strNewFile);
 free(foData.pcData);
 free(pcData);
 exit(4);
 };
free(strNewFile);
iReturn = write(fdFile,foData.pcData,foData.ulLength);
if(iReturn == -1)
 {
 fprintf(stderr,"Couldn't write to output file.\n");
 close(fdFile);
 free(foData.pcData);
 free(pcData);
 exit(5);
 };
iReturn = fchmod(fdFile,S_IRUSR | S_IWUSR | S_IRGRP);
close(fdFile);
if(iReturn == -1)
 {
 fprintf(stderr,"Couldn't grant permissions for output file.\n");
 free(foData.pcData);
 free(pcData);
 exit(6);
 };
free(foData.pcData);
free(pcData);
exit(0);
}
