#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int count ;
char *file_in, *file_out, *passwd;
static int entry_fin_access = 0, entry_fout_access = 0;

void create_dialog_error (gchar *error_message)

{

  GtkWidget *dialog_error;
  GtkWidget *button_ok, *label_error_mesg, *label_space;

  dialog_error = gtk_dialog_new ();
  gtk_window_set_modal (GTK_WINDOW (dialog_error), TRUE);
  
  button_ok = gtk_button_new_with_label ("  Ok  ");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_error)->action_area),
                      button_ok, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (button_ok), "clicked", 
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (dialog_error));
  gtk_widget_show (button_ok);
  
  label_space = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_error)->vbox),
                      label_space, FALSE, FALSE, 0);
  gtk_widget_show (label_space);

  label_error_mesg = gtk_label_new (error_message);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_error)->vbox),
                      label_error_mesg, FALSE, FALSE, 0);
  gtk_widget_show (label_error_mesg);

  gtk_container_set_border_width (GTK_CONTAINER
                                 (GTK_DIALOG (dialog_error)->vbox), 5);
  gtk_widget_show (dialog_error);

}
  
int encrypt(char chin, int key)
{
  char chout;
  chout = ( chin - count + ( 3 * key ) - ( key * key ) + key );
  count = ( count * count - 2 * count );
  return chout;
}

int decrypt(char chin, int key)
{
  char chout;
  chout = ( chin + count - ( 3 * key ) + ( key * key ) - key );
  count = ( count * count - 2 * count);
  return chout;
}

int sumkeyword(char* strpasswd)
{
    int a=0;
    int b=0;
    int all=0;
    for(; a<=strlen(strpasswd); a++)
    {
        for(; b<=strlen(strpasswd); b++)
        {
            all = ( all + strpasswd[a] ) + (strpasswd[b]) - ( strpasswd[( strlen( strpasswd ) - 2 )]*(strlen( strpasswd ) + 3));
        }
    }
    return abs(all);
}

void sfilesel_ok_button_clicked (GtkWidget *sfilesel_ok_button,
                                 GtkWidget *sfilesel)

{

  file_in = gtk_file_selection_get_filename (GTK_FILE_SELECTION (sfilesel));
  entry_fin_access = 1;
  gtk_widget_destroy (sfilesel);

}

void sfilesel_destroy (GtkWidget *sfilesel, GtkWidget *entry_fin)

{

  if (entry_fin_access == 1)
    gtk_entry_set_text (GTK_ENTRY (entry_fin), file_in);
  entry_fin_access = 0;

}

void tfilesel_ok_button_clicked (GtkWidget *tfilesel_ok_button,
                                 GtkWidget *tfilesel)

{

  file_out = gtk_file_selection_get_filename (GTK_FILE_SELECTION (tfilesel));
  entry_fout_access = 1;
  gtk_widget_destroy (tfilesel);

}

void tfilesel_destroy (GtkWidget *tfilesel, GtkWidget *entry_fout)

{

  if (entry_fout_access == 1)
    gtk_entry_set_text (GTK_ENTRY (entry_fout), file_out);
  entry_fout_access = 0;

}

void button_fin_clicked (GtkWidget *button_fin, GtkWidget *entry_fin)

{

  GtkWidget *sfilesel;

  sfilesel = gtk_file_selection_new ("Select Source File");
  gtk_window_set_modal (GTK_WINDOW (sfilesel), TRUE);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (sfilesel)->ok_button),
                      "clicked", GTK_SIGNAL_FUNC (sfilesel_ok_button_clicked),
                       GTK_OBJECT (sfilesel));
  gtk_signal_connect_object 
                     (GTK_OBJECT (GTK_FILE_SELECTION (sfilesel)->cancel_button),
                      "clicked", (GtkSignalFunc) gtk_widget_destroy, 
                      GTK_OBJECT (sfilesel));   
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (sfilesel)), "destroy", 
                      GTK_SIGNAL_FUNC (sfilesel_destroy), 
                      GTK_OBJECT (entry_fin));
  gtk_widget_show (sfilesel);
  
  return;

}

void button_encrypt_clicked (GtkWidget *button_encrypt)

{
  
  char tmpchar;
  int wordsum;
  FILE *inputfile;
  FILE *outputfile;

  /* -- bug fix -- */

  /* we add this bug fix because fopen(..., "r") can't handle the bugs */

  if (file_in != NULL) (tmpchar = *(file_in+(strlen(file_in)-1)));
  
  if (file_in == NULL || strlen(file_in) < 1 || tmpchar == 47) 
    {
      create_dialog_error ("  couldn't open source file  ");
      return;
    }

  /* -- bug fix end -- */
  
  inputfile = fopen (file_in, "r");
  if (!inputfile)
  {
      create_dialog_error ("  couldn't open source file  ");
      return;
  }
  outputfile = fopen (file_out, "w");
  if (!outputfile)
  {
      fclose (inputfile);
      create_dialog_error ("  couldn't open source file  ");
      return;
  }
  
  if (strcmp (file_in, file_out) == 0)
    {
      fclose (inputfile);
      fclose (outputfile);
      create_dialog_error ("  source file and target file are same  ");
      return;
    }

  if (passwd == NULL || strlen(passwd) < 1) 
    {
      fclose (inputfile);
      fclose (outputfile);
      create_dialog_error ("  please give your password  ");
      return;
    }
  
  count = 1;
  wordsum = sumkeyword (passwd);

  if (feof (inputfile))  return;
  while (!feof (inputfile))
  {
      tmpchar = encrypt (fgetc (inputfile), wordsum);
      if (feof (inputfile))
      {
          fclose (inputfile);
          fclose (outputfile);
          create_dialog_error ("     Success !     \nxcrypto-1.0\nNurAmijaya  <amijaya@softhome.net>");
          return;
      }
      fputc (tmpchar, outputfile);
  }
  return;

}

void button_fout_clicked (GtkWidget *button_fout, GtkWidget *entry_fout)

{

  GtkWidget *tfilesel;

  tfilesel = gtk_file_selection_new ("Select Target File");
  gtk_window_set_modal (GTK_WINDOW (tfilesel), TRUE);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (tfilesel)->ok_button),
                      "clicked", GTK_SIGNAL_FUNC (tfilesel_ok_button_clicked),
                       GTK_OBJECT (tfilesel));
  gtk_signal_connect_object 
                     (GTK_OBJECT (GTK_FILE_SELECTION (tfilesel)->cancel_button),
                      "clicked", (GtkSignalFunc) gtk_widget_destroy, 
                      GTK_OBJECT (tfilesel));   
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (tfilesel)), "destroy", 
                      GTK_SIGNAL_FUNC (tfilesel_destroy), 
                      GTK_OBJECT (entry_fout));
  gtk_widget_show (tfilesel);

  return;

}

void button_decrypt_clicked (GtkWidget *button_decrypt)

{

  char tmpchar;
  int wordsum;
  FILE *inputfile;
  FILE *outputfile;

  /* -- bug fix -- */

  /* we add this bug fix because fopen(..., "r") can't handle the bugs */

  if (file_in != NULL) (tmpchar = *(file_in+(strlen(file_in)-1)));
  
  if (file_in == NULL || strlen(file_in) < 1 || tmpchar == 47) 
    {
      create_dialog_error ("  couldn't open source file  ");
      return;
    }

  /* -- bug fix end -- */

  inputfile = fopen (file_in, "r");
  if (!inputfile)
    {
      create_dialog_error ("  couldn't open source file  ");
      return;
    }
  outputfile = fopen (file_out, "w");
  if (!outputfile)
    {
      fclose (inputfile);
      create_dialog_error ("  couldn't open source file  ");
      return;
    }
  
  if (strcmp(file_in, file_out) == 0)
    {
      fclose (inputfile);
      fclose (outputfile);
      create_dialog_error ("  source file and target file are same  ");
      return;
    }

  if (passwd == NULL || strlen(passwd) < 1) 
    {
      fclose (inputfile);
      fclose (outputfile);
      create_dialog_error ("  please give your password  ");
      return;
    }

  count = 1;
  wordsum = sumkeyword (passwd);

  if (feof (inputfile))  return;
  while (!feof (inputfile))
  {
      tmpchar = decrypt (fgetc (inputfile), wordsum);
      if (feof (inputfile))
      {
          fclose (inputfile);
          fclose (outputfile);
          create_dialog_error ("     Success !     \nxcrypto-1.0\nNurAmijaya  <amijaya@softhome.net>");
	  return;
      }
      fputc (tmpchar, outputfile);
   }
  return;

}

void entry_fin_changed (GtkWidget *entry_fin)

{

  file_in = gtk_entry_get_text (GTK_ENTRY (entry_fin));

}

void entry_fout_changed (GtkWidget *entry_fout)

{

  file_out = gtk_entry_get_text (GTK_ENTRY (entry_fout));

}

void entry_passwd_changed (GtkWidget *entry_passwd)

{

  passwd = gtk_entry_get_text (GTK_ENTRY (entry_passwd));

}

void checkbutton_maskpasswd_toggled (GtkWidget *checkbutton_maskpasswd,
                                     gpointer entry_passwd)

{

  gtk_entry_set_visibility (GTK_ENTRY (entry_passwd), 
                           !GTK_TOGGLE_BUTTON (checkbutton_maskpasswd)->active);

}

int main(int argc, gchar *argv[])

{

  GtkWidget *window;
  GtkWidget *vbox_main, *hbox_top, *hbox_middle, *hbox_bottom;
  GtkWidget *button_fin, *button_fout, *button_encrypt, *button_decrypt;
  GtkWidget *button_exit;
  GtkWidget *entry_fin, *entry_fout, *entry_passwd;
  GtkWidget *label, *checkbutton_maskpasswd;

  gtk_init (&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_widget_set_usize (GTK_WIDGET (window), 550, 95);
  gtk_window_set_title (GTK_WINDOW (window), "xcrypto-1.0");
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, TRUE);
  gtk_signal_connect (GTK_OBJECT (window), "destroy", 
                      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

  vbox_main = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox_main);
  gtk_widget_show (vbox_main);

  hbox_top = gtk_hbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox_top), 5);
  gtk_container_add (GTK_CONTAINER (vbox_main), hbox_top);
  gtk_widget_show (hbox_top);

  label = gtk_label_new ("Source File");
  gtk_box_pack_start (GTK_BOX (hbox_top), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  entry_fin = gtk_entry_new_with_max_length (300);
  gtk_box_pack_start (GTK_BOX (hbox_top), entry_fin, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (entry_fin), "changed",
                      GTK_SIGNAL_FUNC (entry_fin_changed), NULL);
  gtk_widget_show (entry_fin);

  button_fin = gtk_button_new_with_label ("Browse");
  gtk_signal_connect (GTK_OBJECT (button_fin), "clicked", 
                      GTK_SIGNAL_FUNC (button_fin_clicked), 
                      (gpointer) entry_fin);
  gtk_box_pack_start (GTK_BOX (hbox_top), button_fin, TRUE, TRUE, 0);
  gtk_widget_show (button_fin);
  
  button_encrypt = gtk_button_new_with_label ("Encrypt");
  gtk_signal_connect (GTK_OBJECT (button_encrypt), "clicked", 
                      GTK_SIGNAL_FUNC (button_encrypt_clicked), 
                      NULL);
  gtk_box_pack_start (GTK_BOX (hbox_top), button_encrypt, TRUE, TRUE, 0);
  gtk_widget_show (button_encrypt);
  
  hbox_middle = gtk_hbox_new (FALSE, 6);
  gtk_container_set_border_width (GTK_CONTAINER (hbox_middle), 5);
  gtk_container_add (GTK_CONTAINER (vbox_main), hbox_middle);
  gtk_widget_show (hbox_middle);
  
  label = gtk_label_new ("Target File ");
  gtk_box_pack_start (GTK_BOX (hbox_middle), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  entry_fout = gtk_entry_new_with_max_length (300);
  gtk_box_pack_start (GTK_BOX (hbox_middle), entry_fout, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (entry_fout), "changed",
                      GTK_SIGNAL_FUNC (entry_fout_changed), NULL);
  gtk_widget_show (entry_fout);

  button_fout = gtk_button_new_with_label ("Browse");
  gtk_signal_connect (GTK_OBJECT (button_fout), "clicked", 
                      GTK_SIGNAL_FUNC (button_fout_clicked), 
                      (gpointer) entry_fout);
  gtk_box_pack_start (GTK_BOX (hbox_middle), button_fout, TRUE, TRUE, 0);
  gtk_widget_show (button_fout);
  
  button_decrypt = gtk_button_new_with_label ("Decrypt");
  gtk_signal_connect (GTK_OBJECT (button_decrypt), "clicked", 
                      GTK_SIGNAL_FUNC (button_decrypt_clicked), 
                      NULL);
  gtk_box_pack_start (GTK_BOX (hbox_middle), button_decrypt, TRUE, TRUE, 0);
  gtk_widget_show (button_decrypt);
  
  hbox_bottom = gtk_hbox_new (FALSE, 4.5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox_bottom), 5);
  gtk_container_add (GTK_CONTAINER (vbox_main), hbox_bottom);
  gtk_widget_show (hbox_bottom);

  label = gtk_label_new ("Password   ");
  gtk_box_pack_start (GTK_BOX (hbox_bottom), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  entry_passwd = gtk_entry_new_with_max_length (50);
  gtk_box_pack_start (GTK_BOX (hbox_bottom), entry_passwd, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (entry_passwd), "changed",
                      GTK_SIGNAL_FUNC (entry_passwd_changed),
                      NULL);
  gtk_widget_show (entry_passwd);

  checkbutton_maskpasswd = gtk_check_button_new_with_label ("Mask Password");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_maskpasswd),
                                TRUE);
  gtk_entry_set_visibility (GTK_ENTRY (entry_passwd), 
                           !GTK_TOGGLE_BUTTON (checkbutton_maskpasswd)->active);
  gtk_signal_connect (GTK_OBJECT (checkbutton_maskpasswd), "toggled", 
                      GTK_SIGNAL_FUNC (checkbutton_maskpasswd_toggled),
                     (gpointer) entry_passwd);
  gtk_box_pack_start (GTK_BOX (hbox_bottom), checkbutton_maskpasswd, TRUE, 
                      TRUE, 0);
  gtk_widget_show (checkbutton_maskpasswd);
  
  button_exit = gtk_button_new_with_label ("       Exit       ");
  gtk_signal_connect (GTK_OBJECT (button_exit), "clicked", 
                      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_box_pack_start (GTK_BOX (hbox_bottom), button_exit, TRUE, TRUE, 0);
  gtk_widget_show (button_exit);
  
  hbox_bottom = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (window);
  gtk_main();
  
  return(0);

}

